import axios from '../request';
import {
  categoryDetailsType,
  categoryListType,
  categoryRelevantType,
  directoryListType,
  directoryPageListType,
} from '~/api/interface/categoryManage';

export class CategoryManageAPI {
  // 分类目录
  static directoryList = (params: { pageNo: number; pageSize: number; type?: any }) => {
    return axios.get('pms/classify/directoryList', {
      params,
    });
  };
  // 分类目录(类型)
  static directoryListClone: directoryPageListType = (params) => {
    return axios.get('pms/classify/directoryList', {
      params,
    });
  };
  // 分类目录-不分页(类型)
  static getDirectoryListClone: directoryListType = (params) => {
    return axios.get('/pms/classify/getDirectoryList', { params });
  };
  // 新增或编辑目录
  static addOrEditDirectory = (data: {
    id?: number;
    directoryName: string;
    type: number;
    show: number[];
  }) => {
    return axios.post('/pms/classify/addOrEditDirectory', data);
  };

  // 删除目录
  static removeDirectory = (id: number) => {
    return axios.get('/pms/classify/removeDirectory', { params: { id } });
  };

  // 分类新增
  static addClassification = (data: object): any => {
    return axios.post('/pms/classify/addClassification', data);
  };

  // 分类列表
  static getClassificationList = (data: object): any => {
    return axios.post(`/pms/classify/getClassificationList`, data);
  };

  static getCategoryList: categoryListType = (data) => {
    return axios.post('/pms/classify/getClassificationList', data);
  };

  // 分类修改
  static updateClassification = (data: object): any => {
    return axios.post('/pms/classify/updateClassification', data);
  };

  // 删除分类
  static deleteRelevantBusiness = (params: object): any => {
    return axios.get('/pms/classify/deleteRelevantBusiness', { params });
  };

  // 分类上下移动
  static exchangeSortType = (params: object): any => {
    return axios.get('/pms/classify/exchangeSortType', { params });
  };

  // 分类详情
  static getGoodsTypeDetail: categoryDetailsType = (params) => {
    return axios.get('/pms/classify/getClassifyDetails', { params });
  };

  // 分类详情-安全编码开发修改
  // static updateIsShowCode = (params: Pick<GoodsInfo, 'goodsId' | 'showCode'>) => {
  //   return axios.get('uavgoods/appgoods/updateIsShowCode', { params });
  // };

  // 分类详情-商品排序
  static exchangeGoodsInfo = (firstId: number, secondId: number) => {
    return axios.get('uavgoods/mgoods/exchangeGoodsInfo', {
      params: { firstId, secondId },
    });
  };

  // 分类详情-图片上传
  static cateGoryDetailUpload = (data: FormData) => {
    return axios.post('ossservlet/upload/imgOss', data);
  };
  // 行业分享码
  static getAppletQRCode(params: { page: string; scene: string }) {
    return axios.get('malluser/wechat/getAppletQRCode', { params });
  }
  //  分类关联列表
  static getRelevantBusiness: categoryRelevantType = (params) => {
    return axios.get('/pms/classify/queryRelevantBusiness', { params });
  };
}
