import { useState } from 'react';
import SearchBox from '~/components/search-box';
import { Button, Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { useNavigate } from 'react-router-dom';
import qs from 'query-string';

// 表格数据类型
type TableType = any;

// 订单状态搜索列表
const statusCodeButtonList = [
  { value: -1, label: '全部订单' },
  { value: 0, label: '沟通意向' },
  { value: 1, label: '签约付款' },
  { value: 2, label: '待发货' },
  { value: 3, label: '待收货' },
  { value: 4, label: '已完成' },
  { value: 5, label: '已关闭' },
];

function ServiceOrderView() {
  // 路由钩子
  const navigate = useNavigate();
  // 当前选择的是第几个按钮
  const [statusCodeButtonIndex, setStatusCodeButtonIndex] = useState<number>(0);
  // 表格分页配置
  const [pagination] = useState({
    total: 0,
    pageSize: 10,
    current: 1,
    totalPage: 0,
  });
  // 表格数据
  const [tableData] = useState<TableType>([{ id: 1 }]);
  // 订单状态筛选
  const statusChangeEvent = (i: number) => {
    console.log('订单状态筛选 --->', i);
    setStatusCodeButtonIndex(i);
  };
  // 跳转订单详情
  const handleDetail = (record: TableType[0]) => {
    console.log('跳转订单详情 --->', record.id);
    navigate(`/orderManage/serviceOrder/detail?${qs.stringify({ id: record.id })}`);
  };
  // 表格结构
  const columns: ColumnsType<TableType[0]> = [
    {
      title: '商品',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '单价(元)',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '数量',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '买家',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '订单状态',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '实收款',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '相关运营',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '推荐人',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '订单交期',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '备注',
      dataIndex: 'remark',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '操作',
      dataIndex: 'action',
      align: 'center',
      fixed: 'right',
      render: (_text, record) => (
        <>
          <Button type={'link'} onClick={() => handleDetail(record)}>
            详情
          </Button>
        </>
      ),
    },
  ];
  return (
    <>
      <SearchBox
        search={[
          {
            label: '订单编号',
            name: 'keyword',
            type: 'input',
            placeholder: '请输入订单编号',
          },
          {
            label: '买家账号',
            name: 'keyword2',
            type: 'input',
            placeholder: '请输入用户账号',
          },
          {
            label: '相关销售',
            name: 'saleId',
            type: 'Select',
            placeholder: '请选择相关销售',
            options: [],
          },
          {
            label: '时间',
            name: 'time',
            type: 'rangePicker',
            placeholder: '请选择创建时间',
          },
        ]}
        searchData={(e: any) => console.log('提交数据 --->', e)}
        sufFixBtn={
          <>
            {statusCodeButtonList?.map((i, j) => {
              return (
                <Button
                  key={j}
                  type={j === statusCodeButtonIndex ? 'primary' : 'default'}
                  onClick={() => statusChangeEvent(j)}
                  style={{ marginTop: '5px' }}
                >
                  {i.label}
                </Button>
              );
            })}
          </>
        }
      />
      <Table
        size='small'
        dataSource={tableData}
        columns={columns}
        rowKey='id'
        scroll={{ x: 1200 }}
        pagination={{
          total: pagination.total,
          pageSize: pagination.pageSize,
          current: pagination.current,
          showSizeChanger: true,
          showQuickJumper: true,
          // onChange: (page: number, pageSize: number) =>
          //   paginationChange(page, pageSize),
          showTotal: (total, range) => `当前 ${range[0]}-${range[1]} 条记录 / 共 ${total} 条数据`,
        }}
        // rowSelection={{ selectedRowKeys, onChange: onSelectChange }}
      />
    </>
  );
}

export default ServiceOrderView;
