import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';

//需求列表
export type listPublishPageType = InterItemFunction<
  { requirementTypeId?: number; keyword?: string },
  {
    id: number;
    publishName: string;
    publishPhone: string;
    requireDescription: string;
    requirementTypeId: number;
    requirementTypeName: string;
  }[]
>;
//需求类型列表
export type requirementsListType = InterFunction<any, { id: number; typeName: string }[]>;
//需求-强制删除
export type deleteRequirementsType = InterFunction<{ requirementsInfoId: number }, any>;
//需求-详情
export type backDetailPublishType = InterFunction<
  { id: number },
  {
    cityCode: number;
    districtCode: number;
    id: number;
    latitude: number;
    longitude: number;
    orderNumber: string;
    paramMoney: number;
    provinceCode: number;
    publishAccountId: number;
    publishName: string;
    publishPhone: number;
    publisherNumber: string;
    requireDescription: string;
    requireUrl: string;
    requirementTypeId: number;
    solved: boolean;
    taskAddress: string;
    taskEndTime: string;
    taskStartTime: string;
    taskTitle: string;
    requirementTypeName: string;
  }
>;

// 查询招标快讯列表-分页
export type releaseTenderNews = InterListFunction<
  {
    endTime?: string;
    startTime?: string;
    tenderName?: string;
    using?: number;
  },
  {
    createTime: Date;
    id: number;
    port: number;
    tenderName: string;
    using: number;
    url: string;
  }
>;
// 新增招标快讯
export type releaseTenderNewsAdd = InterFunction<any, any>;
// 修改招标快讯
export type releaseTenderNewsUpdate = InterFunction<any, any>;
// 删除招标快讯
export type releaseTenderNewsDelete = InterFunction<{ id: number }, any>;
// 查询-招标快讯详情列表-分页
export type releaseTenderNewsInfo = InterListFunction<
  {
    tenderNewsId?: number;
  },
  {
    createTime: string;
    id: number;
    tenderContent: string;
    tenderInfoNo: string;
    tenderNewsId: number;
    tenderPrice: number;
    tenderTitle: string;
  }
>;
// 修改-招标快讯详情
export type releaseTenderNewsInfoUpdate = InterListFunction<
  {
    id: number;
    tenderContent?: string;
    tenderPrice?: number;
    tenderTitle?: string;
  },
  NonNullable<unknown>
>;
// 用户反馈列表-分页
export type releaseTenderNewsApplyList = InterListFunction<
  {
    tenderInfoId?: number;
    tenderNewsId?: number;
    userName?: string;
  },
  {
    createTime: string;
    id: number;
    nickName: string;
    phoneNum: string;
    tenderInfoId: number;
    tenderInfoNo: string;
    tenderTitle: string;
    userName: string;
  }
>;

//行业新闻-列表
export type industryNewsListType = InterItemFunction<
  { newsTitle?: string },
  {
    id: number;
    createTime: string;
    newsAuthor: string;
    newsContents: string;
    newsTitle: string;
    origin: string;
    surfaceImg: string;
    isHot: number;
  }[]
>;
//行业新闻-新增
export type addIndustryNewsType = InterFunction<
  {
    newsAuthor: string;
    newsContents?: string;
    newsTitle: string;
    origin: string;
    surfaceImg: string;
    isHot: number;
  },
  any
>;
//行业新闻-编辑
export type editIndustryNews = InterFunction<
  {
    newsAuthor: string;
    newsContents?: string;
    newsTitle: string;
    origin: string;
    surfaceImg: string;
    id?: number;
  },
  any
>;
//行业新闻-删除
export type deleteIndustryNewsType = InterFunction<{ id: number }, any>;
//行业新闻-详情
export type industryNewsDetailType = InterFunction<
  { id: number },
  {
    id: number;
    createTime: string;
    newsAuthor: string;
    newsContents: string;
    newsTitle: string;
    origin: string;
    surfaceImg: string;
  }
>;

// 案例列表
export type industryCaseListCasePage = InterListFunction<
  {
    cityCode?: number;
    date?: string;
    districtCode?: number;
    keyword?: string;
    provinceCode?: number;
    requirementTypeId?: number;
  },
  {
    caseAuthor: string;
    caseContents: string;
    caseTitle: string;
    createTime: string;
    id: number;
    origin: string;
    surfaceImg: null;
    updateTime: string;
    userAccountId: number;
  }
>;

// 添加业务案例
export type industryCaseAddCase = InterFunction<
  {
    caseAuthor?: string;
    caseContents?: string;
    caseTitle?: string;
    createTime?: string;
    id?: number;
    origin?: string;
    surfaceImg?: string;
    updateTime?: string;
    userAccountId?: number;
  },
  NonNullable<unknown>
>;
// 修改业务案例
export type industryCaseUpdateCase = InterFunction<
  {
    caseAuthor?: string;
    caseContents?: string;
    caseTitle?: string;
    createTime?: string;
    id?: number;
    origin?: string;
    surfaceImg?: string;
    updateTime?: string;
    userAccountId?: number;
  },
  NonNullable<unknown>
>;
// 删除业务案例
export type industryCaseDeleteDetails = InterFunction<{ id: number }, NonNullable<unknown>>;
//后台——系统消息列表
export type selectAllSystemMessage = InterListFunction<
  { id?: number },
  {
    id: number;
    subject: string;
    content: string;
    createTime: string;
    read: boolean;
  }
>;
// 后台发布消息——新增系统消息
export type insertSystemMessage = InterFunction<
  {
    content: string;
    subject: string;
  },
  NonNullable<unknown>
>;
// 后台——删除消息
export type removeMessage = InterFunction<
  {
    id: number;
  },
  NonNullable<unknown>
>;
