import React, { useState } from 'react';
import { Header } from 'antd/es/layout/layout';
import { DownOutlined, UpOutlined } from '@ant-design/icons';
import { Button, Dropdown, MenuProps, Modal } from 'antd';
import Logo from '../../../assets/icon/logo_big.png';
import './index.scss';

export function TitleView() {
  const { confirm } = Modal;
  // 菜单栏是否收起
  const [isActive, setIsActive] = useState(false);
  // 菜单栏收起
  const setMenuCollapsed = () => {
    setIsActive(!isActive);
  };
  // 右上角按钮
  const items: MenuProps['items'] = [
    {
      key: '1',
      label: (
        <Button
          type='link'
          onClick={() => {
            confirm({
              title: '退出登录',
              content: '退出后未保存数据将会丢失，确定登出吗？',
              onOk: () => {
                console.log('点击');
              },
            });
          }}
        >
          退出登录
        </Button>
      ),
    },
  ];
  return (
    <Header
      style={{
        background: '#fff',
        height: 40,
        padding: '0 10px',
        position: 'relative',
      }}
    >
      <div className='layout-logo'>
        <img className='logo-img' src={Logo} alt='云享飞' />
        <div className='logo-text'>云享飞后台管理</div>
        <div onClick={setMenuCollapsed}>
          <svg
            className={`hamburger ${isActive ? 'is-active' : ''}`}
            viewBox='0 0 1024 1024'
            xmlns='http://www.w3.org/2000/svg'
            width='64'
            height='64'
          >
            <path d='M408 442h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-8 204c0 4.4 3.6 8 8 8h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56zm504-486H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 632H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM142.4 642.1L298.7 519a8.84 8.84 0 0 0 0-13.9L142.4 381.9c-5.8-4.6-14.4-.5-14.4 6.9v246.3a8.9 8.9 0 0 0 14.4 7z' />
          </svg>
        </div>
      </div>
      <div className='title-user'>
        <div className='user-content'>
          <div className='user-company'>科比特</div>
          <div className='user-name'>admin</div>
        </div>
        <Dropdown
          overlayStyle={{ textAlign: 'center' }}
          menu={{ items }}
          placement='bottomRight'
          arrow
        >
          <div className='user-action'>
            <UpOutlined style={{ fontSize: 10, color: '#000' }} />
            <DownOutlined style={{ fontSize: 10, color: '#000' }} />
          </div>
        </Dropdown>
      </div>
    </Header>
  );
}
