import axios from '../request';
export class IndustryManageAPI {
  // 行业列表
  static getFirstIndustryTypeInfo = (params: unknown) => {
    return axios.get('uavgoods/appgoods/getFirstGoodsTypeInfo/2', { params });
  };
  // 行业sku管理-方案规格管理-分页列表
  static listPageIndustrySpec = (params: unknown) => {
    return axios.get('uavgoods/industry/spec/listPageIndustrySpec', {
      params,
    });
  };

  // 行业sku管理---分页列表
  static listPageIndustrySku = (data: unknown) => {
    return axios.post('uavgoods/industry/spec/listPageIndustrySku', data);
  };

  // 行业sku管理---新增行业sku
  static addIndustrySku = (data: unknown) => {
    return axios.post('uavgoods/industry/spec/addIndustrySku', data);
  };

  // 行业sku管理---编辑行业sku
  static editIndustrySku = (data: unknown) => {
    return axios.post('uavgoods/industry/spec/editIndustrySku', data);
  };

  // 行业sku管理---删除行业sku
  static removeIndustrySku = (params: unknown) => {
    return axios.get('uavgoods/industry/spec/removeIndustrySku', { params });
  };

  // 行业sku管理-详情-基本信息
  static getIndustrySkuDetail = (params: unknown) => {
    return axios.get('uavgoods/industry/spec/getIndustrySkuDetail', {
      params,
    });
  };

  // 行业sku管理---方案规格管理---新增方案规格
  static addIndustrySpec = (data: unknown) => {
    return axios.post('uavgoods/industry/spec/addIndustrySpec', data);
  };

  // 行业sku管理---方案规格管理---编辑行业规格
  static editIndustrySpec = (data: unknown) => {
    return axios.post('uavgoods/industry/spec/editIndustrySpec', data);
  };

  // 行业sku管理---方案规格管理---删除行业规格
  static removeIndustrySpec = (params: unknown) => {
    return axios.get('uavgoods/industry/spec/removeIndustrySpec', { params });
  };

  // 行业sku管理---方案规格管理---获取价格配置信息  (获取价格配置)
  static getIndustrySpecCPQ = (params: unknown) => {
    return axios.get('uavgoods/industry/spec/getIndustrySpecCPQ', { params });
  };

  // 行业sku管理---方案规格管理---价格配置  (新增价格配置)
  static industrySpecCPQ = (data: unknown) => {
    return axios.post('uavgoods/industry/spec/industrySpecCPQ', data);
  };

  // 行业sku管理---方案规格管理---价格配置信息的修改 (修改价格配置)
  static updateIndustrySpecCPQ = (data: unknown) => {
    return axios.post('uavgoods/industry/spec/updateIndustrySpecCPQ', data);
  };

  // 行业sku管理---方案规格管理---单个方案规格回显 (查看产品清单)
  static getIndustrySpecDetail = (params: unknown) => {
    return axios.get('uavgoods/industry/spec/getIndustrySpecDetail', {
      params,
    });
  };
}
