import React from 'react';
import { Navigate, RouteObject } from 'react-router-dom';
import ErrorPage from '~/pages/common/error';
import LayoutView from '~/components/layout';
import {
  AccountBookOutlined,
  MacCommandOutlined,
  GiftOutlined,
  PayCircleOutlined,
  BarsOutlined,
  ShoppingOutlined,
  ShopOutlined,
  CreditCardOutlined,
  SmileOutlined,
  TeamOutlined,
  ReconciliationOutlined,
  SolutionOutlined,
  RedEnvelopeOutlined,
  SettingOutlined,
  UserOutlined,
  SendOutlined,
  RocketOutlined,
  AppstoreAddOutlined,
  AppstoreOutlined,
  CoffeeOutlined,
  UnorderedListOutlined,
  BookOutlined,
} from '@ant-design/icons';
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
import { AgnosticIndexRouteObject } from '@remix-run/router';
import { Spin } from 'antd';
// 登录
import LoginView from '~/pages/common/login';
// 积分
import { PointList } from '~/pages/pointManage/pointList';
import { PointDetail } from '~/pages/pointManage/pointList/detail';
import { PointRules } from '~/pages/pointManage/pointRules';
import PointDetailList from '~/pages/pointManage/pointDetail';
// 分成
import DivideOrder from '~/pages/pointManage/divideOrder';
import DivideRules from '~/pages/pointManage/divideRules';
// 客户列表
import CustomListView from '~/pages/customManage/customList';
import CustomMoneyView from '~/pages/customManage/customMoney';
import CustomMoneyDetail from '~/pages/customManage/customMoney/detail';
import AccountManageView from '~/pages/systemManage/accountManage';
import CourseManageView from '~/pages/mallManage/courseManage';
// 活动
const ActivityList = React.lazy(() => import('src/pages/activityManage/activityList')); //活动管理

//商品管理
const ServiceListView = React.lazy(() => import('~/pages/mallManage/serviceManage/serviceList')); //服务列表
const ServiceDetailView = React.lazy(
  () => import('~/pages/mallManage/serviceManage/serviceDetail'),
); //服务详情
const ServiceIntroduceView = React.lazy(
  () => import('~/pages/mallManage/serviceManage/serviceIntroduce'),
); //服务介绍
const RentListView = React.lazy(() => import('~/pages/mallManage/rentGoods/rentList')); //租赁列表
const RentAddOrEditOrDetailView = React.lazy(
  () => import('~/pages/mallManage/rentGoods/rentAddOrEditOrDetail'),
); //租赁新增、编辑、详情
const MallGoodsView = React.lazy(() => import('~/pages/mallManage/mallGoods/goodsList')); //商城商品
const MallAddOrEditOrDetailView = React.lazy(
  () => import('~/pages/mallManage/mallGoods/goodsAddOrEditOrDetail'),
); //商城商品新增、编辑、详情
const ProduceListView = React.lazy(() => import('~/pages/mallManage/produceManage/produceList')); //产品列表
const ProduceDetailView = React.lazy(
  () => import('~/pages/mallManage/produceManage/produceDetail'),
); //产品详情
const MakeListView = React.lazy(() => import('~/pages/mallManage/makeManage/makeList'));
const IndustryListView = React.lazy(() => import('~/pages/mallManage/industryManage/industryList')); //行业列表
const IndustryDetailView = React.lazy(
  () => import('~/pages/mallManage/industryManage/industryDetail'),
); //行业详情

// 订单
const ProductOrderView = React.lazy(() => import('src/pages/orderManage/productOrder')); //销售订单
const EquipmentOrderView = React.lazy(() => import('src/pages/orderManage/equipmentOrder')); //设备订单
const ServiceOrderView = React.lazy(() => import('src/pages/orderManage/serviceOrder')); //服务订单
const ProductOrderDetail = React.lazy(() => import('~/pages/orderManage/productOrder/detail'));
const ServiceOrderDetail = React.lazy(() => import('~/pages/orderManage/serviceOrder/detail'));
const EquipmentOrderDetail = React.lazy(() => import('~/pages/orderManage/equipmentOrder/detail'));

// 优惠券
const CouponList = React.lazy(() => import('src/pages/couponManage/couponList')); //优惠券管理
const CouponDetail = React.lazy(() => import('src/pages/couponManage/couponList/detail')); //优惠券明细
const SplitCouponList = React.lazy(() => import('src/pages/couponManage/splitCouponList')); //裂变优惠券
const SplitCouponOperate = React.lazy(
  () => import('src/pages/couponManage/splitCouponList/addOrEditOrDetail'),
); // 裂变优惠券操作
const CouponDetailed = React.lazy(() => import('src/pages/couponManage/couponDetailed')); //优惠券明细

// 分类管理
const CategoryManage = React.lazy(() => import('~/pages/categoryManage/category'));
const CategoryDetail = React.lazy(() => import('~/pages/categoryManage/category/detail'));
// 目录管理
const DirectoryManage = React.lazy(() => import('~/pages/categoryManage/directoryManage'));
export interface RouteObjectType {
  path: AgnosticIndexRouteObject['path'];
  element: any;
  errorElement?: React.ReactNode | null;
  children?: Array<RouteObject & RouteObjectType>;
  meta: {
    id: number;
    hidden?: boolean;
    icon: any;
    customIcon?: boolean;
    title: string;
  };
}
// 加载页面
const withLoadingComponent = (comp: JSX.Element) => (
  <React.Suspense
    fallback={
      <Spin size='large' tip='Loading...'>
        <div style={{ width: '100%', height: '50vh', marginTop: '10vh' }}></div>
      </Spin>
    }
  >
    {comp}
  </React.Suspense>
);
// 路由白名单
export const whiteRouterList: Array<RouteObject & RouteObjectType> = [
  {
    path: '/',
    element: <Navigate to='/orderManage/productOrder' />,
    meta: {
      id: 0,
      title: '销售订单',
      icon: MacCommandOutlined,
    },
    errorElement: <ErrorPage />,
  },
  {
    path: '/login',
    element: withLoadingComponent(<LoginView />),
    meta: {
      id: 0,
      title: '登录',
      icon: MacCommandOutlined,
    },
    errorElement: <ErrorPage />,
  },
];

// 路由数组
export const routerList: Array<RouteObjectType> = [
  {
    path: '/orderManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 10000,
      icon: <BarsOutlined />,
      title: '订单管理',
    },
    children: [
      {
        path: '/orderManage/productOrder',
        element: withLoadingComponent(<ProductOrderView />),
        meta: {
          id: 10010,
          title: '商城订单',
          icon: <ShoppingOutlined />,
        },
      },
      {
        path: '/orderManage/productOrder/detail',
        element: withLoadingComponent(<ProductOrderDetail />),
        meta: {
          id: 10010,
          title: '商城订单 / 详情',
          icon: <ShoppingOutlined />,
          hidden: true,
        },
      },
      {
        path: '/orderManage/equipmentOrder',
        element: withLoadingComponent(<EquipmentOrderView />),
        meta: {
          id: 10020,
          title: '租赁订单',
          icon: <ShopOutlined />,
        },
      },
      {
        path: '/orderManage/equipmentOrder/detail',
        element: withLoadingComponent(<EquipmentOrderDetail />),
        meta: {
          id: 10020,
          title: '租赁订单 / 详情',
          icon: <ShopOutlined />,
          hidden: true,
        },
      },
      {
        path: '/orderManage/serviceOrder',
        element: withLoadingComponent(<ServiceOrderView />),
        meta: {
          id: 10030,
          title: '服务订单',
          icon: <CreditCardOutlined />,
        },
      },
      {
        path: '/orderManage/serviceOrder/detail',
        element: withLoadingComponent(<ServiceOrderDetail />),
        meta: {
          id: 10010,
          title: '服务订单 / 详情',
          icon: <CreditCardOutlined />,
          hidden: true,
        },
      },
    ],
  },
  {
    path: '/mallManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 10100,
      icon: <ShopOutlined />,
      title: '商品管理',
    },
    children: [
      {
        path: '/mallManage/courseManage',
        element: withLoadingComponent(<CourseManageView />),
        meta: {
          id: 10190,
          icon: <BookOutlined />,
          title: '课程管理',
        },
      },
      {
        path: '/mallManage/serviceList',
        element: withLoadingComponent(<ServiceListView />),
        meta: {
          id: 10110,
          icon: <SmileOutlined />,
          title: '服务管理',
        },
      },
      {
        path: '/mallManage/serviceDetail',
        element: withLoadingComponent(<ServiceDetailView />),
        meta: {
          id: 10120,
          icon: <SmileOutlined />,
          title: '服务详情',
          hidden: true,
        },
      },
      {
        path: '/mallManage/serviceIntroduce',
        element: withLoadingComponent(<ServiceIntroduceView />),
        meta: {
          id: 10120,
          icon: <SmileOutlined />,
          title: '服务介绍',
          hidden: true,
        },
      },
      {
        path: '/mallManage/rentGoods',
        element: withLoadingComponent(<RentListView />),
        meta: {
          id: 10130,
          icon: <SmileOutlined />,
          title: '租赁商品',
        },
      },
      {
        path: '/mallManage/rentGoods/add',
        element: withLoadingComponent(<RentAddOrEditOrDetailView />),
        meta: {
          id: 10135,
          icon: <SmileOutlined />,
          title: '租赁商品新增',
          hidden: true,
        },
      },
      {
        path: '/mallManage/rentGoods/edit',
        element: withLoadingComponent(<RentAddOrEditOrDetailView />),
        meta: {
          id: 10136,
          icon: <SmileOutlined />,
          title: '租赁商品编辑',
          hidden: true,
        },
      },
      {
        path: '/mallManage/rentGoods/detail',
        element: withLoadingComponent(<RentAddOrEditOrDetailView />),
        meta: {
          id: 10136,
          icon: <SmileOutlined />,
          title: '租赁商品详情',
          hidden: true,
        },
      },
      {
        path: '/mallManage/mallGoods',
        element: withLoadingComponent(<MallGoodsView />),
        meta: {
          id: 10140,
          icon: <SmileOutlined />,
          title: '商城商品',
        },
      },
      {
        path: '/mallManage/mallGoods/add',
        element: withLoadingComponent(<MallAddOrEditOrDetailView />),
        meta: {
          id: 10145,
          icon: <SmileOutlined />,
          title: '商城商品新增',
          hidden: true,
        },
      },
      {
        path: '/mallManage/mallGoods/edit',
        element: withLoadingComponent(<MallAddOrEditOrDetailView />),
        meta: {
          id: 10146,
          icon: <SmileOutlined />,
          title: '商城商品编辑',
          hidden: true,
        },
      },
      {
        path: '/mallManage/mallGoods/detail',
        element: withLoadingComponent(<MallAddOrEditOrDetailView />),
        meta: {
          id: 10146,
          icon: <SmileOutlined />,
          title: '商城商品详情',
          hidden: true,
        },
      },
      {
        path: '/mallManage/produceList',
        element: withLoadingComponent(<ProduceListView />),
        meta: {
          id: 10150,
          icon: <SmileOutlined />,
          title: '产品管理',
        },
      },
      {
        path: '/mallManage/produceDetail',
        element: withLoadingComponent(<ProduceDetailView />),
        meta: {
          id: 10160,
          icon: <SmileOutlined />,
          title: '产品详情',
          hidden: true,
        },
      },
      {
        path: '/mallManage/makeList',
        element: withLoadingComponent(<MakeListView />),
        meta: {
          id: 10170,
          icon: <SmileOutlined />,
          title: '品牌管理',
        },
      },
      {
        path: '/mallManage/industryList',
        element: withLoadingComponent(<IndustryListView />),
        meta: {
          id: 10180,
          icon: <SmileOutlined />,
          title: '行业方案',
        },
      },
      {
        path: '/mallManage/industryDetail',
        element: withLoadingComponent(<IndustryDetailView />),
        meta: {
          id: 10190,
          icon: <SmileOutlined />,
          title: '行业详情',
          hidden: true,
        },
      },
    ],
  },
  {
    path: '/categoryManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 18000,
      icon: <ReconciliationOutlined />,
      title: '分类管理',
    },
    children: [
      {
        path: '/categoryManage/jobServicesCategory/1',
        element: withLoadingComponent(<CategoryManage />),
        meta: {
          id: 18100,
          title: '作业服务分类',
          icon: <SendOutlined />,
        },
      },
      {
        path: '/categoryManage/jobServicesCategory/2',
        element: withLoadingComponent(<CategoryManage />),
        meta: {
          id: 18200,
          title: '设备租赁分类',
          icon: <RocketOutlined />,
        },
      },
      {
        path: '/categoryManage/jobServicesCategory/3',
        element: withLoadingComponent(<CategoryManage />),
        meta: {
          id: 18300,
          title: '飞手培训分类',
          icon: <AppstoreAddOutlined />,
        },
      },
      {
        path: '/categoryManage/jobServicesCategory/4',
        element: withLoadingComponent(<CategoryManage />),
        meta: {
          id: 18400,
          title: '产品商城分类',
          icon: <AppstoreOutlined />,
        },
      },
      {
        path: '/categoryManage/jobServicesCategory/0',
        element: withLoadingComponent(<CategoryManage />),
        meta: {
          id: 18500,
          title: '通用分类',
          icon: <CoffeeOutlined />,
        },
      },
      {
        path: '/categoryManage/detail/:id',
        element: withLoadingComponent(<CategoryDetail />),
        meta: {
          id: 18600,
          title: '分类详情',
          icon: '',
          hidden: true,
        },
      },
      {
        path: '/categoryManage/DirectoryManage',
        element: withLoadingComponent(<DirectoryManage />),
        meta: {
          id: 18700,
          title: '目录管理',
          icon: <UnorderedListOutlined />,
        },
      },
    ],
  },
  {
    path: '/customManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 22000,
      icon: <TeamOutlined />,
      title: '客户管理',
    },
    children: [
      {
        path: '/customManage/customList',
        element: withLoadingComponent(<CustomListView />),
        meta: {
          id: 26100,
          title: '客户列表',
          icon: <SolutionOutlined />,
        },
      },
      {
        path: '/customManage/customMoney',
        element: withLoadingComponent(<CustomMoneyView />),
        meta: {
          id: 26200,
          title: '现金管理',
          icon: <RedEnvelopeOutlined />,
          hidden: true,
        },
      },
      {
        path: '/customManage/customMoney/detail',
        element: withLoadingComponent(<CustomMoneyDetail />),
        meta: {
          id: 26200,
          title: '现金变更',
          icon: <RedEnvelopeOutlined />,
          hidden: true,
        },
      },
    ],
  },
  {
    path: '/pointManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 25000,
      icon: <AccountBookOutlined />,
      title: '积分管理',
    },
    children: [
      {
        path: '/pointManage/pointList',
        element: withLoadingComponent(<PointList />),
        meta: {
          id: 25100,
          title: '积分列表',
          icon: <MacCommandOutlined />,
        },
      },
      {
        path: '/pointManage/pointList/detail',
        element: withLoadingComponent(
          <PointDetail
            location={{
              search: '',
            }}
          />,
        ),
        meta: {
          id: 25100,
          title: '个人积分明细',
          icon: <MacCommandOutlined />,
          hidden: true,
        },
      },
      {
        path: '/pointManage/pointRule',
        element: withLoadingComponent(<PointRules />),
        meta: {
          id: 25200,
          title: '兑换规则',
          icon: <MacCommandOutlined />,
        },
      },
      {
        path: '/pointManage/pointList/list',
        element: withLoadingComponent(
          <PointDetailList
            location={{
              search: '',
            }}
          />,
        ),
        meta: {
          id: 25100,
          title: '积分明细',
          icon: <MacCommandOutlined />,
          hidden: true,
        },
      },
      {
        path: '/pointManage/divideOrder',
        element: withLoadingComponent(<DivideOrder />),
        meta: {
          id: 25300,
          title: '订单分成',
          icon: <MacCommandOutlined />,
        },
      },
      {
        path: '/pointManage/divideRules',
        element: withLoadingComponent(<DivideRules />),
        meta: {
          id: 25400,
          title: '分成规则',
          icon: <MacCommandOutlined />,
          hidden: true,
        },
      },
    ],
  },
  {
    path: '/couponManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 26000,
      icon: <PayCircleOutlined />,
      title: '优惠券管理',
    },
    children: [
      {
        path: '/couponManage/couponList',
        element: withLoadingComponent(<CouponList />),
        meta: {
          id: 26100,
          title: '活动优惠券',
          icon: <PayCircleOutlined />,
        },
      },
      {
        path: '/couponManage/couponList/detail',
        element: withLoadingComponent(
          <CouponDetail
            location={{
              search: '',
            }}
          />,
        ),
        meta: {
          id: 26100,
          title: '活动优惠券操作',
          icon: <PayCircleOutlined />,
          hidden: true,
        },
      },
      {
        path: '/couponManage/splitCouponList',
        element: withLoadingComponent(<SplitCouponList />),
        meta: {
          id: 26200,
          title: '裂变优惠券',
          icon: <PayCircleOutlined />,
        },
      },
      {
        path: '/couponManage/addOrEditOrDetail',
        element: withLoadingComponent(<SplitCouponOperate />),
        meta: {
          id: 26200,
          title: '裂变优惠券操作',
          icon: <PayCircleOutlined />,
          hidden: true,
        },
      },
      {
        path: '/couponManage/couponDetailed',
        element: withLoadingComponent(<CouponDetailed />),
        meta: {
          id: 26300,
          title: '优惠券明细',
          icon: <PayCircleOutlined />,
        },
      },
    ],
  },
  {
    path: '/activityManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 19000,
      icon: <GiftOutlined />,
      title: '活动管理',
    },
    children: [
      {
        path: '/activityManage/activityList',
        element: withLoadingComponent(<ActivityList />),
        meta: {
          id: 19100,
          title: '活动列表',
          icon: <GiftOutlined />,
        },
      },
    ],
  },
  {
    path: '/systemManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 28000,
      icon: <SettingOutlined />,
      title: '系统管理',
    },
    children: [
      {
        path: '/systemManage/accountManage',
        element: withLoadingComponent(<AccountManageView />),
        meta: {
          id: 28100,
          title: '账号管理',
          icon: <UserOutlined />,
        },
      },
    ],
  },
];
