import { FC, useState } from 'react';
import { Form, Input, Modal, ModalProps } from 'antd';
import { Uploader } from '~/components/uploader';
import { UploadOutlined } from '@ant-design/icons';
import RichText from '~/components/richText';

const AddOrEditNewsModal: FC<ModalProps> = ({ open, onCancel }) => {
  const [richTextValue, setRichTextValue] = useState<string>('');
  const richTextChange = () => {};
  return (
    <Modal open={open} onCancel={onCancel} title='新建' width={800}>
      <Form labelCol={{ span: 4 }} wrapperCol={{ span: 16 }}>
        <Form.Item label='文章标题'>
          <Input placeholder='请输入文章标题' />
        </Form.Item>
        <Form.Item label='文章来源'>
          <Input placeholder='请输入文章来源' />
        </Form.Item>
        <Form.Item label='作者'>
          <Input placeholder='请输入文章作者' />
        </Form.Item>
        <Form.Item label='封面图'>
          <Uploader fileUpload listType='picture-card'>
            <UploadOutlined />
          </Uploader>
        </Form.Item>
        <Form.Item label='主题内容'>
          <RichText onChange={richTextChange} value={richTextValue} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default AddOrEditNewsModal;
