import { FC } from 'react';
import { Button, Image, Modal, ModalProps } from 'antd';
import './index.scss';
const DynamicDetailModal: FC<ModalProps> = ({ open, onCancel }) => {
  return (
    <Modal open={open} onCancel={onCancel} title='查看详情' width={800}>
      <div className='dynamic-detail'>
        <div className='dynamic-detail-media'>
          <Image width={200} height={200} />
        </div>
        <div className='dynamic-detail-info'>
          <div className='info-title'>和男同事两人去夜爬华山，男友提分手怎么办？</div>
          <div className='info-meta'>十一假期和和男同事两人去夜爬华山，男友提分手怎么办？</div>
          <div className='info-footer'>
            <div className='time'>发布于10-18</div>
            <div className='operate'>
              <div>15人回答</div>
              <Button type='link'>88人爱心赞</Button>
            </div>
          </div>
        </div>
        <div className='dynamic-detail-comment'>
          <div className='comment-title'>15条评论</div>
          <div className='comment-item'>
            <div className='comment-item-header'>
              <div className='user-avatar'>
                <img
                  src='https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/cf528825-b958-4ccf-bf0b-a880df9e464c.jpg'
                  alt='头像'
                />
              </div>
              <div className='user-name'>张三</div>
            </div>
            <div className='comment-item-info'>
              <div className='info-content'>不吐槽不骂街，咱们平和来聊聊这件事的底层逻辑。</div>
              <div className='info-time'>10-18</div>
            </div>
          </div>
        </div>
      </div>
    </Modal>
  );
};
export default DynamicDetailModal;
