import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
// 分类列表
export interface categoryEntity {
  id: number;
  directoryId: number;
  classifyName: string;
  pid: number;
  description?: any;
  icon: string;
  remark?: any;
  type: number;
  createTime: string;
  children: any[];
  isADD?: boolean;
  level?: number;
}

// 分类目录
export interface categoryDec {
  id: number;
  directoryName: string;
  pid: null;
  type: number;
  directoryType: string;
}

//分类列表类型
type categoryReposeType = {
  id: number;
  classifyName: string;
  icon: string;
  createTime: string;
  children: categoryReposeType[];
  directoryId: number;
  remark: string;
};
export type categoryListType = InterItemFunction<
  { directoryId?: number; type?: number },
  categoryReposeType[]
>;
//目录列表类型-分页
export type directoryPageListType = InterItemFunction<
  { type?: number },
  {
    id: number;
    directoryName: string;
    type: number;
  }[]
>;
//目录列表类型-不分页
export type directoryListType = InterFunction<
  { type: number },
  {
    id: number;
    directoryName: string;
    type: number;
  }[]
>;
//目录列表-产品指定
export type directoryProductType = InterFunction<
  any,
  {
    id: number;
    directoryName: string;
    type: number;
  }[]
>;
//分类-详情
export type categoryDetailsType = InterFunction<
  { id: number },
  { classifyName: string; description: string; icon: string; id: number; remark: string }
>;
//分类-关联列表
export type categoryRelevantType = InterFunction<{ id: number; type: number }, any>;

//分类管理-分类列表（新）
type categoryItemType = {
  id: number;
  name: string;
  createTime: string;
  icon: string;
  description: string;
  subDTOList: (Omit<categoryItemType, 'createTime' | 'icon' | 'subDTOList' | 'sort'> & {
    categoryPrimaryId: number;
  })[];
  sort: number;
};
export type categoryListRespType = InterItemFunction<{ id?: number }, categoryItemType[]>;
//分类管理-1级分类新增（新）
export type addPrimaryCategoryType = InterFunction<
  {
    description: string;
    icon: string;
    name: string;
  },
  any
>;
//分类管理-1级分类编辑（新）
export type updatePrimaryCategoryType = InterFunction<
  {
    description: string;
    icon: string;
    name: string;
    id?: number;
  },
  any
>;
//分类管理-1级分类删除（新）
export type deletePrimaryCategoryType = InterFunction<{ id: number }, any>;
//分类管理-1级分类交换顺序（新）
export type exchangeType = InterFunction<{ id: number; sort: number }[], any>;

//分类管理-2级分类新增(新)
export type addSubCategoryType = InterFunction<
  {
    categoryPrimaryId: number;
    description: string;
    name: string;
  },
  any
>;
//分类管理-2级分类编辑（新）
export type updateSubCategoryType = InterFunction<
  {
    categoryPrimaryId: number;
    description: string;
    name: string;
    id?: number;
  },
  any
>;
//分类管理-2级分类删除（新）
export type deleteSubCategoryType = InterFunction<{ id: number }, any>;
// 一级行业列表
export type industryListPagesType = InterListFunction<
  {
    id?: number;
    typeName?: string;
  },
  {
    id: number;
    typeName: string;
    typeImg: string;
    description: string;
    saleState: number;
    createTime: string;
    inspectionDTOS: Array<{
      id: number;
      inspectionNo: string;
      inspectionName: string;
      industryTypeId: number;
      inspectionImg: string;
      inspectionDescription: string;
      saleState: null;
      caseImg: string;
      caseVideo: string;
      companyInspectionDTOS: null;
    }>;
    inspectionName: string;
    inspectionImg: string;
    inspectionDescription: string;
  }
>;
// 新增行业
export type industryInsertType = InterFunction<
  {
    description?: string;
    id?: number;
    saleState?: number;
    typeImg?: string;
    typeName?: string;
  },
  NonNullable<unknown>
>;
// 修改行业
export type industryUpdateType = InterFunction<
  {
    description?: string;
    id?: number;
    saleState?: number;
    typeImg?: string;
    typeName?: string;
  },
  NonNullable<unknown>
>;
// 新增服务
export type inspectionInsertType = InterFunction<
  {
    caseImg?: string;
    caseVideo?: string;
    id?: number;
    industryTypeId?: number;
    inspectionDescription?: string;
    inspectionImg?: string;
    inspectionName?: string;
    inspectionNo?: string;
    saleState?: number;
  },
  NonNullable<unknown>
>;
// 修改服务
export type inspectionUpdateType = InterFunction<
  {
    caseImg?: string;
    caseVideo?: string;
    id?: number;
    industryTypeId?: number;
    inspectionDescription?: string;
    inspectionImg?: string;
    inspectionName?: string;
    inspectionNo?: string;
    saleState?: number;
  },
  NonNullable<unknown>
>;
// 删除行业
export type industryRemoveType = InterFunction<{ id: number }, NonNullable<unknown>>;
// 删除服务
export type inspectionRemoveType = InterFunction<{ id: number }, NonNullable<unknown>>;
// 根据服务id查询标签列表
export type listByInspectionIdType = InterFunction<
  { id: number },
  {
    id: number;
    inspectionId: number;
    tagName: string;
  }[]
>;
// 新增服务标签
export type inspectionTagInsertType = InterFunction<
  {
    id?: number;
    inspectionId?: number;
    tagName?: string;
  },
  NonNullable<unknown>
>;
// 修改服务标签
export type inspectionTagUpdateType = InterFunction<
  {
    id?: number;
    inspectionId?: number;
    tagName?: string;
  },
  NonNullable<unknown>
>;
// 删除服务标签
export type inspectionTagDeleteType = InterFunction<
  {
    id: number;
  },
  NonNullable<unknown>
>;
// 服务详情
export type inspectionDetailType = InterFunction<
  {
    id: number;
  },
  {
    caseImg: string;
    caseVideo: string;
    companyInspectionDTOS: Array<{
      companyInfoId: number;
      companyName: string;
      detailPage: string;
      id: number;
      industryTypeDTO: {
        createTime: string;
        description: string;
        id: number;
        inspectionDTOS: null;
        saleState: number;
        typeImg: string;
        typeName: string;
      };
      inspectionDTO: null;
      inspectionFileDTOS: Array<{
        companyInspectionId: number;
        fileType: number;
        fileUrl: string;
        first: number;
        id: number;
      }>;
      inspectionFirstImg: string;
      inspectionId: number;
      inspectionPriceUnitId: number;
      inspectionTagDTO: {
        id: number;
        inspectionId: number;
        tagName: string;
      };
      inspectionTagId: number;
      price: number;
      priceRemark: string;
      remark: string;
      saleState: number;
      serviceArea: string;
    }>;
    createTime: string;
    id: number;
    industryTypeId: number;
    inspectionDescription: string;
    inspectionImg: string;
    inspectionName: string;
    inspectionNo: string;
    saleState: number;
  }
>;
