import { useSearchParams, useNavigate } from 'react-router-dom';
import { useEffect, useState } from 'react';
import { SystemManageAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { listMenuInfoType } from '~/api/interface/systemManageType';
import { Button, message, Modal, Tree } from 'antd';
import './index.scss';

//菜单类型
type menuType = InterDataType<listMenuInfoType>;

const LimitInfo = () => {
  const navigate = useNavigate();
  const [searchParams] = useSearchParams();
  const [roleId, setRoleId] = useState<number>(-1);
  const [allMenu, setAllMenu] = useState<any>();
  const [checkedKeys, setCheckedKeys] = useState<number[]>([]);
  const [menuInfoIds, setMenuInfoIds] = useState<number[]>([]); //编辑请求数组
  //获取全部菜单
  const getListMenuInfo = () => {
    SystemManageAPI.getListMenuInfo().then(({ result }) => {
      setAllMenu({
        ...result,
        children: result.children?.sort((a, b) => a?.id - b?.id),
      });
    });
  };
  //根据id获取该角色菜单
  const getListRoleMenuInfo = (roleId: number) => {
    SystemManageAPI.getListRoleMenuInfo({ roleId }).then(({ result }) => {
      setCheckedKeys(getChildKeys(result.children));
      setMenuInfoIds(getAllKeys(result.children));
    });
  };
  //获取叶子节点
  const getChildKeys = (data: menuType[]) => {
    return data.reduce((pre: number[], cur) => {
      if (cur.children) {
        pre.push(...getChildKeys(cur.children));
      } else {
        pre.push(cur.id);
      }
      return pre;
    }, []);
  };
  //获取全部节点
  const getAllKeys = (data: menuType[]) => {
    return data.reduce((pre: number[], cur) => {
      pre.push(cur.id);
      if (cur.children) {
        pre.push(...getAllKeys(cur.children));
      }
      return pre;
    }, []);
  };
  //菜单选中
  const menuCheckEvent = (checkedKeys: any, info: any) => {
    setCheckedKeys(checkedKeys);
    setMenuInfoIds(checkedKeys.concat(info.halfCheckedKeys));
  };
  //更新菜单权限
  const updateRoleMenuInfo = () => {
    Modal.confirm({
      title: '修改权限',
      content: '确认修改该角色权限',
      onOk: () => {
        SystemManageAPI.updateRoleMenuInfo({ roleId, menuInfoIds }).then(({ code }) => {
          if (code === '200') {
            message.success('修改成功');
          }
        });
      },
    });
  };
  //返回
  const backRoute = () => {
    navigate(-1);
  };
  useEffect(() => {
    setRoleId(Number(searchParams.get('id')));
    getListRoleMenuInfo(Number(searchParams.get('id')));
    getListMenuInfo();
  }, []);
  return (
    <div className='limit-info'>
      <div className='limit-info-operate'>
        <Button type='primary' onClick={updateRoleMenuInfo}>
          修改
        </Button>
        <Button type='primary' onClick={backRoute}>
          返回
        </Button>
      </div>
      <div className='limit-info-content'>
        {allMenu && (
          <Tree
            checkable
            treeData={[allMenu]}
            fieldNames={{ title: 'menuName', key: 'id' }}
            defaultExpandAll
            checkedKeys={checkedKeys}
            onCheck={menuCheckEvent}
          />
        )}
      </div>
    </div>
  );
};
export default LimitInfo;
