import React from 'react';
import { RouteObject } from 'react-router-dom';
import ErrorPage from '~/pages/common/error';
import LayoutView from '~/components/layout';
import {
  MacCommandOutlined,
  BarsOutlined,
  ShoppingOutlined,
  ShopOutlined,
  CreditCardOutlined,
  SmileOutlined,
  TeamOutlined,
  ReconciliationOutlined,
  SolutionOutlined,
  RedEnvelopeOutlined,
  SettingOutlined,
  UserOutlined,
  SendOutlined,
  RocketOutlined,
  AppstoreAddOutlined,
  AppstoreOutlined,
  CoffeeOutlined,
  UnorderedListOutlined,
  BookOutlined,
  SketchOutlined,
  DribbbleOutlined,
  MessageOutlined,
  AliwangwangOutlined,
  AuditOutlined,
  MonitorOutlined,
  PictureOutlined,
  PaperClipOutlined,
  ReadOutlined,
  ThunderboltOutlined,
  BankOutlined,
  VerifiedOutlined,
  AccountBookOutlined,
} from '@ant-design/icons';
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
import { AgnosticIndexRouteObject } from '@remix-run/router';
import { Spin } from 'antd';
// 登录
import LoginView from '~/pages/common/login';

// 积分
import { PointList } from '~/pages/pointManage/pointList';
import { PointDetail } from '~/pages/pointManage/pointList/detail';
// import { PointRules } from '~/pages/pointManage/pointRules';
// import PointDetailList from '~/pages/pointManage/pointDetail';
// 分成
// import DivideOrder from '~/pages/pointManage/divideOrder';
// import DivideRules from '~/pages/pointManage/divideRules';
// 活动
// const ActivityList = React.lazy(() => import('src/pages/activityManage/activityList')); //活动管理
// 客户管理
import CustomListView from '~/pages/customManage/customList';
import CustomMoneyView from '~/pages/customManage/customMoney';
import CustomMoneyDetail from '~/pages/customManage/customMoney/detail';
const CustomVerificationView = React.lazy(
  () => import('~/pages/customManage/customVerification/list'),
); //实名认证
const CustomVerificationDetailView = React.lazy(
  () => import('~/pages/customManage/customVerification/details'),
);

//资源管理
import MaterielManageView from '~/pages/resourceManage/materielManage';
import MaterielManageDetail from '~/pages/resourceManage/materielManage/detail';
const GatheringListView = React.lazy(
  () => import('~/pages/resourceManage/requirementsGathering/gatherList'),
); //需求收集列表
const GatherDetailView = React.lazy(
  () => import('~/pages/resourceManage/requirementsGathering/gatherDetail'),
);

const TagManageView = React.lazy(() => import('~/pages/resourceManage/tagManage')); //标签管理
const IndustryNewsView = React.lazy(() => import('~/pages/resourceManage/industryNews'));
//论坛管理
const DynamicListView = React.lazy(() => import('~/pages/forumManage/dynamicList'));
// 订单
const ProductOrderView = React.lazy(() => import('src/pages/orderManage/productOrder')); //销售订单
const EquipmentOrderView = React.lazy(() => import('src/pages/orderManage/equipmentOrder')); //设备订单
const ServiceOrderView = React.lazy(() => import('src/pages/orderManage/serviceOrder')); //服务订单
const ProductOrderDetail = React.lazy(() => import('~/pages/orderManage/productOrder/detail'));
const ServiceOrderDetail = React.lazy(() => import('~/pages/orderManage/serviceOrder/detail'));
const EquipmentOrderDetail = React.lazy(() => import('~/pages/orderManage/equipmentOrder/detail'));
const PilotTrainingOrderView = React.lazy(() => import('~/pages/orderManage/pilotTrainingOrder'));

//商品管理
import CourseManageView from '~/pages/mallManage/courseManage'; //课程管理
const ServiceListView = React.lazy(() => import('~/pages/mallManage/serviceManage/serviceList')); //服务列表
const ServiceDetailView = React.lazy(
  () => import('~/pages/mallManage/serviceManage/serviceDetail'),
); //服务详情
const ServiceIntroduceView = React.lazy(
  () => import('~/pages/mallManage/serviceManage/serviceIntroduce'),
); //服务介绍
const RentListView = React.lazy(() => import('~/pages/mallManage/rentGoods/rentList')); //租赁列表
const RentAddOrEditOrDetailView = React.lazy(
  () => import('~/pages/mallManage/rentGoods/rentAddOrEditOrDetail'),
); //租赁新增、编辑、详情
const MallGoodsView = React.lazy(() => import('~/pages/mallManage/mallGoods/goodsList')); //商城商品
const MallAddOrEditOrDetailView = React.lazy(
  () => import('~/pages/mallManage/mallGoods/goodsAddOrEditOrDetail'),
); //商城商品新增、编辑、租赁商品详情
const MallGoodsDetailsView = React.lazy(() => import('~/pages/mallManage/mallGoods/goodsDetails')); //商城商品（新）

const ProduceListView = React.lazy(() => import('~/pages/mallManage/produceManage/produceList')); //产品列表
const ProduceDetailView = React.lazy(
  () => import('~/pages/mallManage/produceManage/produceDetail'),
); //产品详情
const MakeListView = React.lazy(() => import('~/pages/mallManage/makeManage/makeList'));
// 分类管理
const MallCategoryListView = React.lazy(() => import('~/pages/categoryManage/mallCategoryList')); //商城分类
const ServiceCategoryListView = React.lazy(
  () => import('~/pages/categoryManage/serviceCategoryList'),
); //服务分类
const CategoryManage = React.lazy(() => import('~/pages/categoryManage/category'));
const CategoryDetail = React.lazy(() => import('~/pages/categoryManage/category/detail'));
// 目录管理
const DirectoryManage = React.lazy(() => import('~/pages/categoryManage/directoryManage'));

//执照培训
const InstitutionsListView = React.lazy(
  () => import('~/pages/pilotTraining/ licensureExamination/institutionsList'),
); //机构列表
const AddInstitutionsView = React.lazy(
  () => import('~/pages/pilotTraining/ licensureExamination/addOrEditInstitution'),
); //机构上传

//飞手中心
const FlyerListView = React.lazy(() => import('~/pages/flyerCenter/flyerManage/flyerList')); //飞手列表
const FlyerAuthDailyView = React.lazy(
  () => import('~/pages/flyerCenter/flyerManage/flyerAuthDaily'),
); //飞手认证日志;
const FlyerDetailsView = React.lazy(() => import('~/pages/flyerCenter/flyerManage/flyerDetail')); //飞手详情、飞手审批

// 系统管理
import AccountManageView from '~/pages/systemManage/accountManage';
import TenderManageView from '~/pages/resourceManage/tenderManage';
import TenderManageDetail from '~/pages/resourceManage/tenderManage/detail';
import TenderManageFeedback from '~/pages/resourceManage/tenderManage/feedback';
import BusinessCaseManage from '~/pages/resourceManage/businessCaseManage';
import CustomIdentityView from '~/pages/customManage/customIdentity';
import CompanyListView from '~/pages/systemManage/companyManage/companyList'; //单位列表
const CompanyDetailView = React.lazy(
  () => import('~/pages/systemManage/companyManage/companyDetail'),
);
import AccountLimit from '~/pages/systemManage/limitManage/roleList'; //账号权限
import LimitInfo from '~/pages/systemManage/limitManage/limitInfo';
import CustomListDetail from '~/pages/customManage/customList/detail';

// const IndustryListView = React.lazy(() => import('~/pages/mallManage/industryManage/industryList')); //行业列表
// const IndustryDetailView = React.lazy(
//   () => import('~/pages/mallManage/industryManage/industryDetail'),
// ); //行业详情

// 优惠券
// const CouponList = React.lazy(() => import('src/pages/couponManage/couponList')); //优惠券管理
// const CouponDetail = React.lazy(() => import('src/pages/couponManage/couponList/detail')); //优惠券明细
// const SplitCouponList = React.lazy(() => import('src/pages/couponManage/splitCouponList')); //裂变优惠券
// const SplitCouponOperate = React.lazy(
//   () => import('src/pages/couponManage/splitCouponList/addOrEditOrDetail'),
// ); // 裂变优惠券操作
// const CouponDetailed = React.lazy(() => import('src/pages/couponManage/couponDetailed')); //优惠券明细

export interface RouteObjectType {
  path: AgnosticIndexRouteObject['path'];
  element: any;
  errorElement?: React.ReactNode | null;
  children?: Array<RouteObject & RouteObjectType>;
  meta: {
    id: number;
    hidden?: boolean;
    icon: any;
    customIcon?: boolean;
    title: string;
    develop?: boolean;
  };
}
// 加载页面
const withLoadingComponent = (comp: JSX.Element) => (
  <React.Suspense
    fallback={
      <Spin size='large' tip='Loading...'>
        <div style={{ width: '100%', height: '50vh', marginTop: '10vh' }}></div>
      </Spin>
    }
  >
    {comp}
  </React.Suspense>
);
// 路由白名单
export const whiteRouterList: Array<RouteObject & RouteObjectType> = [
  {
    path: '/login',
    element: withLoadingComponent(<LoginView />),
    meta: {
      id: 0,
      title: '登录',
      icon: MacCommandOutlined,
    },
    errorElement: <ErrorPage />,
  },
];

// 路由数组
export const routerList: Array<RouteObjectType> = [
  {
    path: '/customManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 200,
      icon: <TeamOutlined />,
      title: '客户管理',
    },
    children: [
      {
        path: '/customManage/customList',
        element: withLoadingComponent(<CustomListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 220,
          title: '客户列表',
          icon: <SolutionOutlined />,
        },
      },
      {
        path: '/customManage/customVerification',
        element: withLoadingComponent(<CustomVerificationView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 260,
          title: '实名认证',
          icon: <SolutionOutlined />,
        },
      },
      {
        path: '/customManage/customVerificationDetail',
        element: withLoadingComponent(<CustomVerificationDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 250,
          title: '实名认证详情',
          hidden: true,
          icon: <SolutionOutlined />,
        },
      },
      {
        path: '/customManage/customList/detail',
        element: withLoadingComponent(<CustomListDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 220,
          title: '邀请列表',
          icon: <SolutionOutlined />,
          hidden: true,
        },
      },
      {
        path: '/customManage/customMoney',
        element: withLoadingComponent(<CustomMoneyView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 26200,
          title: '现金管理',
          icon: <RedEnvelopeOutlined />,
          hidden: true,
        },
      },
      {
        path: '/customManage/customMoney/detail',
        element: withLoadingComponent(<CustomMoneyDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 26200,
          title: '现金变更',
          icon: <RedEnvelopeOutlined />,
          hidden: true,
        },
      },
      {
        path: '/customManage/customIdentity',
        element: withLoadingComponent(<CustomIdentityView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 240,
          title: '加盟入驻',
          icon: <AuditOutlined />,
        },
      },
    ],
  },
  {
    path: '/flyerCenter',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 1800,
      icon: <UserOutlined />,
      title: '飞手中心',
    },
    children: [
      {
        path: '/flyerCenter/flyerList',
        element: withLoadingComponent(<FlyerListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1810,
          title: '飞手管理',
          icon: <UserOutlined />,
        },
      },
      {
        path: '/flyerCenter/flyerAuthDaily',
        element: withLoadingComponent(<FlyerAuthDailyView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1815,
          title: '认证日志',
          hidden: true,
          icon: <UserOutlined />,
        },
      },
      {
        path: '/flyerCenter/flyerDetail',
        element: withLoadingComponent(<FlyerDetailsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1816,
          title: '飞手详情',
          hidden: true,
          icon: <UserOutlined />,
        },
      },
      {
        path: '/flyerCenter/flyerApprove',
        element: withLoadingComponent(<FlyerDetailsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1817,
          title: '飞手审批',
          hidden: true,
          icon: <UserOutlined />,
        },
      },
    ],
  },
  {
    path: '/resourceManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 400,
      icon: <DribbbleOutlined />,
      title: '资源管理',
    },
    children: [
      {
        path: '/resourceManage/requirementsGathering',
        element: withLoadingComponent(<GatheringListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 410,
          title: '需求收集',
          icon: <MonitorOutlined />,
        },
      },
      {
        path: '/resourceManage/gatherDetail',
        element: withLoadingComponent(<GatherDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 415,
          title: '需求详情',
          hidden: true,
          icon: <MonitorOutlined />,
        },
      },
      {
        path: '/resourceManage/materielManage',
        element: withLoadingComponent(<MaterielManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 420,
          title: '宣传管理',
          icon: <PictureOutlined />,
        },
      },
      {
        path: '/resourceManage/materielManage/detail',
        element: withLoadingComponent(<MaterielManageDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 30100,
          title: '宣传管理详情',
          icon: <SketchOutlined />,
          hidden: true,
        },
      },
      {
        path: '/resourceManage/tagManage',
        element: withLoadingComponent(<TagManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 430,
          title: '标签管理',
          icon: <PaperClipOutlined />,
        },
      },
      {
        path: '/resourceManage/industryNews',
        element: withLoadingComponent(<IndustryNewsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 440,
          title: '行业新闻',
          icon: <ReadOutlined />,
        },
      },
      {
        path: '/resourceManage/tenderManage',
        element: withLoadingComponent(<TenderManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 450,
          title: '招标快讯',
          icon: <CoffeeOutlined />,
        },
      },
      {
        path: '/resourceManage/tenderManage/detail',
        element: withLoadingComponent(<TenderManageDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 30500,
          title: '招标快讯详情',
          icon: <CoffeeOutlined />,
          hidden: true,
        },
      },
      {
        path: '/resourceManage/tenderManage/feedback',
        element: withLoadingComponent(<TenderManageFeedback />),
        errorElement: <ErrorPage />,
        meta: {
          id: 30500,
          title: '用户反馈',
          icon: <CoffeeOutlined />,
          hidden: true,
        },
      },
      {
        path: '/resourceManage/businessCaseManage',
        element: withLoadingComponent(<BusinessCaseManage />),
        errorElement: <ErrorPage />,
        meta: {
          id: 460,
          title: '业务案例',
          icon: <AliwangwangOutlined />,
        },
      },
    ],
  },
  {
    path: '/forumManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 600,
      icon: <MessageOutlined />,
      title: '论坛管理',
    },
    children: [
      {
        path: '/forumManage/dynamicList',
        element: withLoadingComponent(<DynamicListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 610,
          title: '动态列表',
          icon: <ThunderboltOutlined />,
        },
      },
    ],
  },
  {
    path: '/orderManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 800,
      icon: <BarsOutlined />,
      title: '订单管理',
    },
    children: [
      {
        path: '/orderManage/productOrder',
        element: withLoadingComponent(<ProductOrderView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 810,
          title: '商城订单',
          icon: <ShoppingOutlined />,
        },
      },
      {
        path: '/orderManage/productOrder/detail',
        element: withLoadingComponent(<ProductOrderDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10010,
          title: '商城订单 / 详情',
          icon: <ShoppingOutlined />,
          hidden: true,
        },
      },
      {
        path: '/orderManage/equipmentOrder',
        element: withLoadingComponent(<EquipmentOrderView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 820,
          title: '租赁订单',
          icon: <ShopOutlined />,
        },
      },
      {
        path: '/orderManage/equipmentOrder/detail',
        element: withLoadingComponent(<EquipmentOrderDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10020,
          title: '租赁订单 / 详情',
          icon: <ShopOutlined />,
          hidden: true,
        },
      },
      {
        path: '/orderManage/serviceOrder',
        element: withLoadingComponent(<ServiceOrderView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 830,
          title: '服务订单',
          icon: <CreditCardOutlined />,
        },
      },
      {
        path: '/orderManage/serviceOrder/detail',
        element: withLoadingComponent(<ServiceOrderDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10010,
          title: '服务订单 / 详情',
          icon: <CreditCardOutlined />,
          hidden: true,
        },
      },
      {
        path: '/orderManage/pilotTrainingOrder',
        element: withLoadingComponent(<PilotTrainingOrderView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10040,
          title: '培训订单',
          icon: <CreditCardOutlined />,
        },
      },
    ],
  },
  {
    path: '/mallManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 1000,
      icon: <ShopOutlined />,
      title: '商品管理',
    },
    children: [
      {
        path: '/mallManage/serviceList',
        element: withLoadingComponent(<ServiceListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1020,
          icon: <SmileOutlined />,
          title: '服务管理',
        },
      },
      {
        path: '/mallManage/serviceDetail',
        element: withLoadingComponent(<ServiceDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10120,
          icon: <SmileOutlined />,
          title: '服务详情',
          hidden: true,
        },
      },
      {
        path: '/mallManage/serviceIntroduce',
        element: withLoadingComponent(<ServiceIntroduceView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10120,
          icon: <SmileOutlined />,
          title: '服务介绍',
          hidden: true,
        },
      },
      {
        path: '/mallManage/rentGoods',
        element: withLoadingComponent(<RentListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1030,
          icon: <SmileOutlined />,
          title: '租赁商品',
        },
      },
      {
        path: '/mallManage/rentGoods/add',
        element: withLoadingComponent(<RentAddOrEditOrDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10135,
          icon: <SmileOutlined />,
          title: '租赁商品新增',
          hidden: true,
        },
      },
      {
        path: '/mallManage/rentGoods/edit',
        element: withLoadingComponent(<RentAddOrEditOrDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10136,
          icon: <SmileOutlined />,
          title: '租赁商品编辑',
          hidden: true,
        },
      },
      {
        path: '/mallManage/rentGoods/detail',
        element: withLoadingComponent(<RentAddOrEditOrDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10136,
          icon: <SmileOutlined />,
          title: '租赁商品详情',
          hidden: true,
        },
      },
      {
        path: '/mallManage/mallGoods',
        element: withLoadingComponent(<MallGoodsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1040,
          icon: <SmileOutlined />,
          title: '商城商品',
        },
      },
      {
        path: '/mallManage/mallGoods/add',
        element: withLoadingComponent(<MallAddOrEditOrDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10145,
          icon: <SmileOutlined />,
          title: '商城商品新增',
          hidden: true,
        },
      },
      {
        path: '/mallManage/mallGoods/edit',
        element: withLoadingComponent(<MallAddOrEditOrDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10146,
          icon: <SmileOutlined />,
          title: '商城商品编辑',
          hidden: true,
        },
      },
      {
        path: '/mallManage/mallGoods/detail',
        element: withLoadingComponent(<MallGoodsDetailsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10146,
          icon: <SmileOutlined />,
          title: '商城商品详情',
          hidden: true,
        },
      },
      {
        path: '/mallManage/produceList',
        element: withLoadingComponent(<ProduceListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1050,
          icon: <SmileOutlined />,
          title: '产品管理',
        },
      },
      {
        path: '/mallManage/produceDetail',
        element: withLoadingComponent(<ProduceDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 10160,
          icon: <SmileOutlined />,
          title: '产品详情',
          hidden: true,
        },
      },
      {
        path: '/mallManage/makeList',
        element: withLoadingComponent(<MakeListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1060,
          icon: <SmileOutlined />,
          title: '品牌管理',
        },
      },
      // {
      //   path: '/mallManage/industryList',
      //   element: withLoadingComponent(<IndustryListView />),
      //   meta: {
      //     id: 10180,
      //     icon: <SmileOutlined />,
      //     title: '行业方案',
      //   },
      // },
      // {
      //   path: '/mallManage/industryDetail',
      //   element: withLoadingComponent(<IndustryDetailView />),
      //   meta: {
      //     id: 10190,
      //     icon: <SmileOutlined />,
      //     title: '行业详情',
      //     hidden: true,
      //   },
      // },
    ],
  },
  {
    path: '/categoryManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 1200,
      icon: <ReconciliationOutlined />,
      title: '分类管理',
    },
    children: [
      {
        path: '/categoryManage/jobServicesCategory/1',
        element: withLoadingComponent(<CategoryManage />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1210,
          title: '作业服务分类',
          icon: <SendOutlined />,
        },
      },
      //  作业服务分类（新）
      // {
      //   path: '/categoryManage/serviceCategoryList',
      //   element: withLoadingComponent(<ServiceCategoryListView />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 1210,
      //     title: '作业服务分类',
      //     icon: <SendOutlined />,
      //   },
      // },
      {
        path: '/categoryManage/jobServicesCategory/2',
        element: withLoadingComponent(<CategoryManage />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1220,
          title: '设备租赁分类',
          icon: <RocketOutlined />,
        },
      },
      {
        path: '/categoryManage/jobServicesCategory/3',
        element: withLoadingComponent(<CategoryManage />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1230,
          title: '飞手培训分类',
          icon: <AppstoreAddOutlined />,
        },
      },
      //  产品商城分类（新）
      {
        path: '/categoryManage/mallCategoryList',
        element: withLoadingComponent(<MallCategoryListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1240,
          title: '产品商城分类',
          icon: <AppstoreOutlined />,
        },
      },
      // {
      //   path: '/categoryManage/jobServicesCategory/4',
      //   element: withLoadingComponent(<CategoryManage />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 1240,
      //     title: '产品商城分类',
      //     icon: <AppstoreOutlined />,
      //   },
      // },
      {
        path: '/categoryManage/jobServicesCategory/0',
        element: withLoadingComponent(<CategoryManage />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1250,
          title: '通用分类',
          icon: <CoffeeOutlined />,
        },
      },
      {
        path: '/categoryManage/detail/:id',
        element: withLoadingComponent(<CategoryDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 18600,
          title: '分类详情',
          icon: '',
          hidden: true,
        },
      },
      {
        path: '/categoryManage/DirectoryManage',
        element: withLoadingComponent(<DirectoryManage />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1260,
          title: '目录管理',
          icon: <UnorderedListOutlined />,
        },
      },
    ],
  },
  {
    path: '/pointManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 12000,
      icon: <AccountBookOutlined />,
      title: '积分管理',
      develop: true,
    },
    children: [
      {
        path: '/pointManage/pointList',
        element: withLoadingComponent(<PointList />),
        meta: {
          id: 12100,
          title: '积分列表',
          icon: <MacCommandOutlined />,
          develop: true,
        },
      },
      {
        path: '/pointManage/pointList/detail',
        element: withLoadingComponent(<PointDetail />),
        meta: {
          id: 12110,
          title: '个人积分明细',
          icon: <MacCommandOutlined />,
          hidden: true,
        },
      },
      // {
      //   path: '/pointManage/pointRule',
      //   element: withLoadingComponent(<PointRules />),
      //   meta: {
      //     id: 25200,
      //     title: '兑换规则',
      //     icon: <MacCommandOutlined />,
      //   },
      // },
      // {
      //   path: '/pointManage/pointList/list',
      //   element: withLoadingComponent(
      //     <PointDetailList
      //       location={{
      //         search: '',
      //       }}
      //     />,
      //   ),
      //   meta: {
      //     id: 25100,
      //     title: '积分明细',
      //     icon: <MacCommandOutlined />,
      //     hidden: true,
      //   },
      // },
      // {
      //   path: '/pointManage/divideOrder',
      //   element: withLoadingComponent(<DivideOrder />),
      //   meta: {
      //     id: 25300,
      //     title: '订单分成',
      //     icon: <MacCommandOutlined />,
      //   },
      // },
      // {
      //   path: '/pointManage/divideRules',
      //   element: withLoadingComponent(<DivideRules />),
      //   meta: {
      //     id: 25400,
      //     title: '分成规则',
      //     icon: <MacCommandOutlined />,
      //     hidden: true,
      //   },
      // },
    ],
  },
  // {
  //   path: '/couponManage',
  //   element: <LayoutView />,
  //   errorElement: <ErrorPage />,
  //   meta: {
  //     id: 26000,
  //     icon: <PayCircleOutlined />,
  //     title: '优惠券管理',
  //   },
  //   children: [
  //     {
  //       path: '/couponManage/couponList',
  //       element: withLoadingComponent(<CouponList />),
  //       meta: {
  //         id: 26100,
  //         title: '活动优惠券',
  //         icon: <PayCircleOutlined />,
  //       },
  //     },
  //     {
  //       path: '/couponManage/couponList/detail',
  //       element: withLoadingComponent(
  //         <CouponDetail
  //           location={{
  //             search: '',
  //           }}
  //         />,
  //       ),
  //       meta: {
  //         id: 26100,
  //         title: '活动优惠券操作',
  //         icon: <PayCircleOutlined />,
  //         hidden: true,
  //       },
  //     },
  //     {
  //       path: '/couponManage/splitCouponList',
  //       element: withLoadingComponent(<SplitCouponList />),
  //       meta: {
  //         id: 26200,
  //         title: '裂变优惠券',
  //         icon: <PayCircleOutlined />,
  //       },
  //     },
  //     {
  //       path: '/couponManage/addOrEditOrDetail',
  //       element: withLoadingComponent(<SplitCouponOperate />),
  //       meta: {
  //         id: 26200,
  //         title: '裂变优惠券操作',
  //         icon: <PayCircleOutlined />,
  //         hidden: true,
  //       },
  //     },
  //     {
  //       path: '/couponManage/couponDetailed',
  //       element: withLoadingComponent(<CouponDetailed />),
  //       meta: {
  //         id: 26300,
  //         title: '优惠券明细',
  //         icon: <PayCircleOutlined />,
  //       },
  //     },
  //   ],
  // },
  // {
  //   path: '/activityManage',
  //   element: <LayoutView />,
  //   errorElement: <ErrorPage />,
  //   meta: {
  //     id: 19000,
  //     icon: <GiftOutlined />,
  //     title: '活动管理',
  //   },
  //   children: [
  //     {
  //       path: '/activityManage/activityList',
  //       element: withLoadingComponent(<ActivityList />),
  //       meta: {
  //         id: 19100,
  //         title: '活动列表',
  //         icon: <GiftOutlined />,
  //       },
  //     },
  //   ],
  // },
  {
    path: '/pilotTraining',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 1600,
      icon: <BankOutlined />,
      title: '执照培训',
    },
    children: [
      {
        path: '/pilotTraining/institutionsList',
        element: withLoadingComponent(<InstitutionsListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1610,
          title: '执照考试',
          icon: <VerifiedOutlined />,
        },
      },
      {
        path: '/pilotTraining/institutionsList/add',
        element: withLoadingComponent(<AddInstitutionsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1520,
          title: '机构上传',
          icon: <UserOutlined />,
          hidden: true,
        },
      },
      {
        path: '/pilotTraining/institutionsList/edit',
        element: withLoadingComponent(<AddInstitutionsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1530,
          title: '机构编辑',
          icon: <UserOutlined />,
          hidden: true,
        },
      },
      {
        path: '/pilotTraining/courseManage',
        element: withLoadingComponent(<CourseManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1010,
          icon: <BookOutlined />,
          title: '课程管理',
        },
      },
    ],
  },
  {
    path: '/systemManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 1400,
      icon: <SettingOutlined />,
      title: '系统管理',
    },
    children: [
      {
        path: '/systemManage/accountManage',
        element: withLoadingComponent(<AccountManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1410,
          title: '账号管理',
          icon: <UserOutlined />,
        },
      },
      {
        path: '/systemManage/accountLimit',
        element: withLoadingComponent(<AccountLimit />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1420,
          title: '权限角色',
          icon: <TeamOutlined />,
        },
      },
      {
        path: '/systemManage/limitInfo',
        element: withLoadingComponent(<LimitInfo />),
        errorElement: <ErrorPage />,
        meta: {
          id: 28300,
          title: '权限信息',
          icon: <UserOutlined />,
          hidden: true,
        },
      },
      {
        path: '/systemManage/companyList',
        element: withLoadingComponent(<CompanyListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1430,
          title: '单位列表',
          icon: <BankOutlined />,
        },
      },
      {
        path: '/systemManage/companyDetail',
        element: withLoadingComponent(<CompanyDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1440,
          title: '单位详情',
          icon: <BankOutlined />,
          hidden: true,
        },
      },
    ],
  },
];
