import SearchBox, { searchColumns as searchColumnsType } from '~/components/search-box';
import { Button, Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { useEffect, useState } from 'react';
import { CustomManageAPI } from '~/api';
import { InterDataType, InterReqListType, PaginationProps } from '~/api/interface';
import { listAuthPageType } from '~/api/interface/customManageType';
import { useNavigate } from 'react-router-dom';
import RemarkModal from '~/pages/customManage/customVerification/list/components/remarkModal';

//实名认证列表返回类型
type listAuthType = InterDataType<listAuthPageType>['list'];
//实名认证列表请求类型
type listAuthParametersType = InterReqListType<listAuthPageType>;

const CustomVerification = () => {
  const navigate = useNavigate();

  const searchColumns: searchColumnsType[] = [
    {
      name: 'keyword',
      label: '用户信息',
      type: 'input',
      placeholder: '请输入UID,姓名或手机号',
    },
  ];
  const tableColumns: ColumnsType<listAuthType[0]> = [
    {
      title: 'UID',
      align: 'center',
      dataIndex: 'uid',
    },
    {
      title: '昵称',
      align: 'center',
      dataIndex: 'nickName',
    },
    {
      title: '姓名',
      align: 'center',
      dataIndex: 'userName',
    },
    {
      title: '手机号',
      align: 'center',
      dataIndex: 'phoneNum',
    },
    {
      title: '时间',
      align: 'center',
      dataIndex: 'createTime',
    },
    {
      title: '备注',
      align: 'center',
      dataIndex: 'remark',
      width: '20%',
      ellipsis: true,
      render: (text: string, record) => (
        <Button type='link' onClick={() => remarkModalShowClick(record)}>
          {text || '--'}
        </Button>
      ),
    },
    {
      title: '操作',
      align: 'center',
      render: (_text: string, record) => (
        <Button type='link' onClick={() => toCustomVerificationDetail(record)}>
          详情
        </Button>
      ),
    },
  ];
  const [tableData, setTableData] = useState<listAuthType>([]);
  const [query, setQuery] = useState<listAuthParametersType>();

  const [pagination, setPagination] = useState<PaginationProps & { totalCount: number }>({
    pageNo: 1,
    pageSize: 10,
    totalCount: 0,
  });
  //备注弹窗
  const [remarkModalShow, setRemarkModalShow] = useState<boolean>(false);
  const [currentAuthItem, setCurrentAuthItem] = useState<listAuthType[0]>();

  const getAuthList = (query?: listAuthParametersType) => {
    CustomManageAPI.getListAuth({
      pageNo: pagination.pageNo,
      pageSize: pagination.pageSize,
      ...query,
    }).then(({ result }) => {
      pagination.totalCount = result.totalCount;
      setPagination(pagination);
      setTableData(result.list || []);
    });
  };
  //分页
  const paginationChange = (pageNo: number, pageSize: number) => {
    pagination.pageNo = pageNo;
    pagination.pageSize = pageSize;
    getAuthList(query);
  };
  //筛选成功
  const searchSuccess = (value: listAuthParametersType) => {
    pagination.pageNo = 1;
    pagination.pageSize = 10;
    setQuery(value);
    getAuthList(value);
  };
  //认证详情
  const toCustomVerificationDetail = (record: listAuthType[0]) => {
    navigate({ pathname: '/customManage/customVerificationDetail', search: `id=${record.id}` });
  };

  //修改备注操作
  const remarkModalShowClick = (record: listAuthType[0]) => {
    setCurrentAuthItem({ ...record });
    setRemarkModalShow(true);
  };
  const remarkModalCancel = () => {
    setRemarkModalShow(false);
  };
  const remarkModalOk = () => {
    getAuthList(query);
    setRemarkModalShow(false);
  };

  useEffect(() => {
    getAuthList();
  }, []);

  return (
    <div className='custom-verification'>
      <SearchBox search={searchColumns} searchData={searchSuccess} />
      <Table
        columns={tableColumns}
        bordered
        dataSource={tableData}
        rowKey='id'
        pagination={{
          total: pagination.totalCount,
          pageSize: pagination.pageSize,
          current: pagination.pageNo,
          showSizeChanger: true,
          showQuickJumper: true,
          onChange: (page: number, pageSize: number) => paginationChange(page, pageSize),
          showTotal: (total, range) => `当前 ${range[0]}-${range[1]} 条记录 / 共 ${total} 条数据`,
        }}
      />
      <RemarkModal
        open={remarkModalShow}
        onCancel={remarkModalCancel}
        onOk={remarkModalOk}
        currentAuthItem={currentAuthItem}
      />
    </div>
  );
};
export default CustomVerification;
