import SearchBox, { searchColumns } from '~/components/search-box';
import { Button, Table, Image } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
import { useEffect, useState } from 'react';
import AddOrEditTagModal from './components/addOrEditTagModal';
import { InterDataType, InterReqType } from '~/api/interface';
import { cooperationListTag } from '~/api/interface/customManageType';
import { CustomManageAPI } from '~/api';

// 列表类型
type TableType = InterDataType<cooperationListTag>;
// 请求的参数
type ReqType = InterReqType<cooperationListTag>;
// 搜索表单的数据
let query: ReqType = {};

//行业新闻
const TagManage = () => {
  const searchColumnsData: searchColumns[] = [
    {
      label: '标签名称',
      placeholder: '请输入标签名称',
      name: '',
      type: 'input',
    },
  ];
  const tableColumns: ColumnsType<any> = [
    {
      title: '序号',
      align: 'center',
      render: (_text, _record, index) => (pagination.current - 1) * pagination.pageSize + index + 1,
    },
    {
      title: '标签名称',
      align: 'center',
      dataIndex: 'tagName',
    },
    {
      title: '标签描述',
      align: 'center',
      dataIndex: 'tagDescription',
      width: '250px',
      ellipsis: true,
    },
    {
      title: '标签需求',
      align: 'center',
      dataIndex: 'tagRequire',
      width: '250px',
      ellipsis: true,
    },
    {
      title: '标签等级图标',
      align: 'center',
      dataIndex: 'tagImg',
      render: (text) => <Image src={text} alt={'图标'} style={{ width: '32px', height: '32px' }} />,
    },
    {
      title: '操作',
      align: 'center',
      fixed: 'right',
      width: '100px',
      render: () => (
        <>
          <Button type='link'>编辑</Button>
          <Button type='link' danger>
            删除
          </Button>
        </>
      ),
    },
  ];
  // 表格数据
  const [tableData, setTableData] = useState<TableType>([]);
  // 表格分页配置
  // eslint-disable-next-line @typescript-eslint/no-unused-vars,@typescript-eslint/ban-ts-comment
  // @ts-ignore
  const [pagination, setPagination] = useState({
    total: 0,
    pageSize: 10,
    current: 1,
    totalPage: 0,
  });
  // 加载列表
  const getTableList = async (value = {}) => {
    // 只需要修改这个地方的接口即可
    const res = await CustomManageAPI.cooperationListTag({
      pageNo: pagination.current,
      pageSize: pagination.pageSize,
      ...value,
      ...query,
    });
    if (res && res.code === '200') {
      // const { list, pageNo, totalCount, pageSize, totalPage } = res.result; // 解构
      // setPagination({
      //   total: totalCount,
      //   current: pageNo,
      //   pageSize,
      //   totalPage,
      // });
      setTableData(res.result);
    }
  };
  // 翻页
  // eslint-disable-next-line @typescript-eslint/no-unused-vars,@typescript-eslint/ban-ts-comment
  // @ts-ignore
  const paginationChange = (pageNo: number, pageSize: number) => {
    getTableList({ pageNo, pageSize }).then();
  };
  // 表单提交
  const onFinish = (data: ReqType) => {
    pagination.current = 1;
    query = data;
    getTableList(data).then();
  };
  const [addOrEditTagModalShow, setAddOrEditTagModalShow] = useState<boolean>(false);

  const addOrEditTagClick = () => {
    setAddOrEditTagModalShow(true);
  };
  const addOrEditTagModalCancel = () => {
    setAddOrEditTagModalShow(false);
  };
  useEffect(() => {
    getTableList().then();
  }, []);
  return (
    <div className='tag-manage'>
      <SearchBox
        search={searchColumnsData}
        child={
          <Button type='primary' icon={<PlusOutlined />} onClick={addOrEditTagClick}>
            新建
          </Button>
        }
        searchData={onFinish}
      />
      <Table
        bordered
        columns={tableColumns}
        dataSource={tableData}
        rowKey='id'
        size={'small'}
      ></Table>
      <AddOrEditTagModal open={addOrEditTagModalShow} onCancel={addOrEditTagModalCancel} />
    </div>
  );
};
export default TagManage;
