import { authRouterList, router } from '~/router/index';
import { RouterProvider } from 'react-router-dom';
import { useEffect } from 'react';
import Cookies from 'js-cookie';
import { message } from 'antd';

function PrivateRouter() {
  // 路由钩子
  // const location = useLocation();
  // 在切换路由之前判断
  const beforeEach = () => {
    // TODO: 判断是否登录 (需要改为实时获取地址栏的路由)
    const path = location.pathname;
    const token = Cookies.get('SHAREFLY_TOKEN');
    if (!token && path !== '/login') {
      location.replace('/login');
      return;
    }
    // 如果该用户没有权限，跳转到登录页
    if (authRouterList().length === 0) {
      message.info('请先配置权限！', 2000).then(() => {
        location.replace('/login');
      });
      return;
    }
  };
  useEffect(() => {
    beforeEach();
  }, [location.pathname]);
  return <RouterProvider router={router} />;
}

export default PrivateRouter;
