import React from 'react';
import { Button } from 'antd';
import { mallOrderDetailType } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';
import { contractStatusList } from '~/utils/dictionary';
import { FddInterfaceAPI } from '~/api';
import { decode } from 'js-base64';
import FileSaver from 'file-saver';

// 接口返回的类型
type DataType = InterDataType<mallOrderDetailType>;
// 参数类型
type PropsType = {
  detail: DataType | undefined;
};

const DetailPurchaser: React.FC<PropsType> = ({ detail }) => {
  //   合同预览
  const contractPreview = () => {
    if (detail?.contractInfoDTO?.contractNo) {
      FddInterfaceAPI.viewContract({ contractId: detail?.contractInfoDTO?.contractNo }).then(
        ({ result }) => {
          window.open(decode(result), '_blank');
        },
      );
    }
  };
  // 合同下载
  const downloadContract = () => {
    if (detail?.contractInfoDTO?.contractNo) {
      FddInterfaceAPI.downloadContract({ contractId: detail?.contractInfoDTO?.contractNo }).then(
        ({ result }) => {
          FileSaver.saveAs(decode(result), `${detail?.contractInfoDTO?.contractNo}.pdf`);
        },
      );
    }
  };

  return (
    <div className='detail-purchaser detail-half'>
      <div className='detail-title'>买家信息</div>
      <div className='detail-text'>UID：</div>
      <div className='detail-text'>姓名： </div>
      <div className='detail-text'>手机号： </div>
      <div className='detail-text'>备注：</div>
      {detail?.contractInfoDTO ? (
        <div>
          <div className='detail-title'>合同信息</div>
          <div className='detail-text'>合同编号： {detail.contractInfoDTO.contractNo}</div>
          <div className='detail-text'>合同标题： {detail.contractInfoDTO.contractTitle}</div>
          <div className='detail-text'>
            合同状态：
            <span style={{ color: 'red' }}>
              {
                contractStatusList.find((v) => v.value === detail.contractInfoDTO?.signStatus)
                  ?.label
              }
            </span>
          </div>
          <div className='detail-text'>
            合同操作：
            <Button type='link' onClick={contractPreview}>
              查看
            </Button>
            <Button type='link' onClick={downloadContract}>
              下载
            </Button>
          </div>
        </div>
      ) : (
        ''
      )}
      {/*<div className={'detail-title'}>付款凭证</div>*/}
      {/*<div className={'detail-text'}>预付款：</div>*/}
      {/*<div className={'detail-image'}>*/}
      {/*  {[*/}
      {/*    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',*/}
      {/*    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',*/}
      {/*  ].map((i, j) => (*/}
      {/*    <Image key={j} className={'image'} src={i} alt='付款凭证' />*/}
      {/*  ))}*/}
      {/*</div>*/}
      {/*<div className={'detail-text'}>尾款：</div>*/}
      {/*<div className={'detail-image'}>*/}
      {/*  {[*/}
      {/*    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',*/}
      {/*    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',*/}
      {/*  ].map((i, j) => (*/}
      {/*    <Image key={j} className={'image'} src={i} alt='付款凭证' />*/}
      {/*  ))}*/}
      {/*</div>*/}
      {/*<div className={'detail-text'}>全款：</div>*/}
      {/*<div className={'detail-image'}>*/}
      {/*  {[*/}
      {/*    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',*/}
      {/*    'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',*/}
      {/*  ].map((i, j) => (*/}
      {/*    <Image key={j} className={'image'} src={i} alt='付款凭证' />*/}
      {/*  ))}*/}
      {/*</div>*/}
    </div>
  );
};

export default DetailPurchaser;
