import SearchBox from '~/components/search-box';
import { Button, Table } from 'antd';
import { useEffect, useState } from 'react';
import { OrderManageAPI } from '~/api';
import { ColumnsType } from 'antd/es/table/InternalTable';
import { useNavigate } from 'react-router-dom';

const ProcurementOrderList = () => {
  const navigate = useNavigate();

  // 订单状态
  const [orderStatusList, setOrderStatusList] = useState<{ value: number; label: string }[]>([]);
  // 订单状态搜索列表
  const [tranStatusList, setTranStatusList] = useState<
    { value: number | undefined; label: string }[]
  >([]);
  // 当前选择的是第几个按钮
  const [statusCodeButtonIndex, setStatusCodeButtonIndex] = useState<number>(0);

  // 表格数据
  const [tableData, setTableData] = useState<any>([{ id: 1 }]);
  const tableColumns: ColumnsType<any> = [
    {
      title: '商品',
      align: 'center',
    },
    {
      title: '订单金额(元)',
      align: 'center',
    },
    {
      title: '买家',
      align: 'center',
    },
    {
      title: '订单状态',
      align: 'center',
    },
    {
      title: '实收款',
      align: 'center',
    },
    {
      title: '推荐人',
      align: 'center',
    },
    {
      title: '订单交期',
      align: 'center',
    },
    {
      title: '备注',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
      render: () => (
        <Button type='link' onClick={toProcurementOrderDetail}>
          详情
        </Button>
      ),
    },
  ];

  // 获取订单状态
  const getOrderStatus = () => {
    OrderManageAPI.orderListStatus({}).then(({ result }) => {
      const list = result.map((item) => ({ value: item.code, label: item.status }));
      setOrderStatusList(list);
      const arr = list
        .filter((i) => [999, 800, 720, 300, 200, 100, 50].includes(i.value))
        .reverse();
      setTranStatusList([{ value: undefined, label: '全部订单' }, ...arr]);
    });
  };
  // 订单状态筛选
  const statusChangeEvent = (i: number) => {
    if (i === statusCodeButtonIndex) {
      setStatusCodeButtonIndex(0);
    } else {
      setStatusCodeButtonIndex(i);
    }
  };
  // 采购订单详情
  const toProcurementOrderDetail = () => {
    navigate('/orderManage/procurementOrder/detail');
  };

  useEffect(() => {
    getOrderStatus();
  }, []);
  return (
    <div className='procurement-order-list'>
      <SearchBox
        search={[
          {
            label: '订单编号',
            name: 'keyword',
            type: 'input',
            placeholder: '请输入订单编号',
          },
          {
            label: '买家账号',
            name: 'keyword2',
            type: 'input',
            placeholder: '请输入用户账号',
          },
          {
            label: '时间',
            name: 'rangeTime',
            type: 'rangePicker',
            placeholder: '请选择创建时间',
          },
        ]}
        sufFixBtn={
          <>
            {tranStatusList?.map((i, j) => {
              return (
                <Button
                  key={j}
                  type={j === statusCodeButtonIndex ? 'primary' : 'default'}
                  onClick={() => statusChangeEvent(j)}
                  style={{ marginTop: '5px' }}
                >
                  {i.label}
                </Button>
              );
            })}
          </>
        }
      />
      <Table bordered columns={tableColumns} dataSource={tableData} />
    </div>
  );
};
export default ProcurementOrderList;
