import { Button, Descriptions, Table } from 'antd';
import { useNavigate } from 'react-router-dom';

const ProcurementOrderDetail = () => {
  const navigate = useNavigate();

  const backRoute = () => {
    navigate(-1);
  };
  return (
    <div className='procurement-order-detail'>
      <Descriptions
        title='供应商'
        bordered
        extra={
          <Button type='primary' onClick={backRoute}>
            返回
          </Button>
        }
      >
        <Descriptions.Item label='供应商名称：'>供应商名称：</Descriptions.Item>
        <Descriptions.Item label='供应商电话：'>供应商电话：</Descriptions.Item>
        <Descriptions.Item label='Live'>Hangzhou, Zhejiang</Descriptions.Item>
      </Descriptions>
      <Descriptions title='订单' style={{ marginTop: '10px' }} column={3}>
        <Descriptions.Item label='订单编号：' labelStyle={{ color: '#000' }}>
          1
        </Descriptions.Item>
        <Descriptions.Item label='创建时间：' labelStyle={{ color: '#000' }}>
          2
        </Descriptions.Item>
        <Descriptions.Item label='合同编号：' labelStyle={{ color: '#000' }}>
          3
        </Descriptions.Item>
        <Descriptions.Item span={3}>
          <Table bordered style={{ width: '100%' }} />
        </Descriptions.Item>
      </Descriptions>
      <Descriptions title='物流' bordered style={{ marginTop: '10px' }}>
        <Descriptions.Item label='收货人：'>供应商名称：</Descriptions.Item>
        <Descriptions.Item label='手机号：'>供应商电话：</Descriptions.Item>
        <Descriptions.Item label='收货地址：'>Hangzhou, Zhejiang</Descriptions.Item>
        <Descriptions.Item label='物流单号：'>Hangzhou, Zhejiang</Descriptions.Item>
        <Descriptions.Item label='物流进度：'>Hangzhou, Zhejiang</Descriptions.Item>
      </Descriptions>
      <Descriptions title='凭证' bordered style={{ marginTop: '10px' }}>
        <Descriptions.Item label='付款凭证：'>供应商名称：</Descriptions.Item>
        <Descriptions.Item label='验收商品：'>供应商电话：</Descriptions.Item>
        <Descriptions.Item label='合同信息：'>Hangzhou, Zhejiang</Descriptions.Item>
      </Descriptions>
    </div>
  );
};
export default ProcurementOrderDetail;
