import { InterFunction } from '~/api/interface';

//fdd-企业实名认证
export type companyVerifyUrlType = InterFunction<{ port: number }, string>;
// fdd-企业实名认证信息
export type userFddInfoType = InterFunction<
  { port: number },
  {
    id: number;
    unionId: string;
    customerId: string;
    personVerifyStatus: number;
    entVerifyStatus: number;
    accountType: number;
    createTime: string;
    updateTime: string;
  }
>;

// fdd-上传合同
export type uploadContractType = InterFunction<
  {
    /**
     * 合同地址
     */
    docUrl: string;
    /**
     * 订单编号
     */
    orderNo: string;
    /**
     * 端口：0小程序 1后台
     */
    port: number;
    /**
     * 合同标题
     */
    title: string;
  },
  {
    id: number;
    unionId: string;
    orderNo: string;
    contractNo: string;
    contractTitle: string;
    signStatus: number;
    singerTime: string;
    createTime: string;
    updateTime: string;
    archiveDate: string;
    aremark: string;
    bremark: string;
    atransactionId: number;
    btransactionId: number;
  }
>;
// fdd-签署合同
export type signContractType = InterFunction<
  {
    /**
     * 合同编号
     */
    contractId: string;
    /**
     * 小程序页面跳转地址
     */
    pages?: string;
    /**
     * 端口：0小程序 1后台
     */
    port: number;
  },
  string
>;
// fdd-合同预览
export type viewContractType = InterFunction<{ contractId: string }, string>;
// fdd-合同下载
export type downloadContractType = InterFunction<{ contractId: string }, string>;
