import { Form, Input, Modal, ModalProps, Radio, RadioChangeEvent, Button, message } from 'antd';
import React, { FC, useState } from 'react';
import { InterDataType } from '~/api/interface';
import { rentOrderDetailType } from '~/api/interface/orderManageType';
import LogisticsStepModal from '~/components/order/productOrder/logisticsStepModal';
import { OrderManageAPI } from '~/api';

// 租赁订单详情返回类型
type detailType = InterDataType<rentOrderDetailType>;

interface selfProps {
  onOk: () => void;
  onCancel: () => void;
  currentOrderItem: detailType | undefined;
  modalTitle: string;
}

const ConfirmReturn: FC<ModalProps & selfProps> = ({
  open,
  onOk,
  onCancel,
  currentOrderItem,
  modalTitle,
}) => {
  const [form] = Form.useForm<{ damage: number; reason: string }>();
  const [isShowReason, setIsShowReason] = useState<boolean>(false);
  const [logisticsStepModalShow, setLogisticsStepModalShow] = useState<boolean>(false);

  const radioChangeEvent = (e: RadioChangeEvent) => {
    setIsShowReason(!!e.target.value);
  };
  // 物流弹窗
  const logisticsStepModalShowClick = () => {
    setLogisticsStepModalShow(true);
  };
  const logisticsStepModalCancel = () => {
    setLogisticsStepModalShow(false);
  };

  const handleOk = () => {
    form.validateFields().then((values) => {
      OrderManageAPI.rentPfConfirmOrderWare({
        ...values,
        orderId: currentOrderItem?.id,
      }).then(({ code }) => {
        if (code === '200') {
          message.success('确认归还成功');
          form.resetFields();
          setIsShowReason(false);
          onOk();
        }
      });
    });
  };
  const handleCancel = () => {
    onCancel();
    form.resetFields();
    setIsShowReason(false);
  };

  return (
    <Modal open={open} onOk={handleOk} onCancel={handleCancel} title={modalTitle}>
      <Form initialValues={{ damage: 0 }} form={form}>
        <Form.Item label='判定' name='damage'>
          <Radio.Group onChange={radioChangeEvent}>
            <Radio value={0}>未破损</Radio>
            <Radio value={1}>破损</Radio>
          </Radio.Group>
        </Form.Item>
        {isShowReason ? (
          <Form.Item label='原因' name='reason'>
            <Input.TextArea placeholder='请输入原因' maxLength={70} showCount rows={3} />
          </Form.Item>
        ) : (
          ''
        )}
        <Form.Item label='物流信息'>
          <div>
            <Button type='link' onClick={logisticsStepModalShowClick}>
              查看详情
            </Button>
          </div>
        </Form.Item>
        <LogisticsStepModal
          open={logisticsStepModalShow}
          onCancel={logisticsStepModalCancel}
          logisticsStep={currentOrderItem?.returnKdnExpDTO}
        />
      </Form>
    </Modal>
  );
};

export default ConfirmReturn;
