import SearchBox from '~/components/search-box';
import { Button, message, Modal, Table } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
import AddOrEditAddressModal from '~/pages/systemManage/addressManage/components/addOrEditAddressModal';
import { useEffect, useState } from 'react';
import { SystemManageAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { addressListType } from '~/api/interface/systemManageType';

//地址列表返回类型
type addressType = InterDataType<addressListType>;

const AddressManage = () => {
  const tableColumns: ColumnsType<addressType[0]> = [
    {
      title: '姓名',
      align: 'center',
      dataIndex: 'takeName',
    },
    {
      title: '电话',
      align: 'center',
      dataIndex: 'takePhone',
    },
    {
      title: '所在地区',
      align: 'center',
      dataIndex: 'takeRegion',
    },
    {
      title: '详细地址',
      align: 'center',
      dataIndex: 'takeAddress',
    },
    {
      title: '状态',
      align: 'center',
      dataIndex: 'type',
      render: (text: number) => (!text ? '默认' : ''),
    },
    {
      title: '操作',
      align: 'center',
      render: (_: any, record) => (
        <>
          <Button type='link' onClick={() => addOrEditAddressModalClick(record)}>
            编辑
          </Button>
          <Button type='link' onClick={() => deleteAddressClick(record)}>
            删除
          </Button>
        </>
      ),
    },
  ];

  const [addressList, setAddressList] = useState<addressType>([]);
  const [addOrEditAddressModalShow, setAddOrEditAddressModalShow] = useState<boolean>(false);
  const [currentAddressItem, setCurrentAddressItem] = useState<addressType[0]>();

  const getAddressList = () => {
    SystemManageAPI.getAddressList({}).then(({ result }) => {
      setAddressList(result);
    });
  };
  //新增，编辑地址
  const addOrEditAddressModalClick = (record?: addressType[0]) => {
    setCurrentAddressItem(record ? { ...record } : undefined);
    setAddOrEditAddressModalShow(true);
  };
  const addOrEditAddressModalCancel = () => {
    setAddOrEditAddressModalShow(false);
  };
  const addOrEditAddressModalOk = () => {
    getAddressList();
    setAddOrEditAddressModalShow(false);
  };

  //地址删除
  const deleteAddressClick = (record: addressType[0]) => {
    Modal.confirm({
      title: '提示',
      content: '确认删除该地址吗？',
      onOk: () => {
        SystemManageAPI.deleteAddress({ id: record.id }).then(({ code }) => {
          if (code === '200') {
            message.success('删除成功');
            getAddressList();
          }
        });
      },
    });
  };

  useEffect(() => {
    getAddressList();
  }, []);

  return (
    <div className='address-manage'>
      <SearchBox
        child={
          <Button
            type='primary'
            icon={<PlusOutlined />}
            onClick={() => addOrEditAddressModalClick()}
          >
            新增地址
          </Button>
        }
      />
      <Table bordered columns={tableColumns} dataSource={addressList} rowKey='id' />

      {/*新增编辑地址*/}
      <AddOrEditAddressModal
        open={addOrEditAddressModalShow}
        onCancel={addOrEditAddressModalCancel}
        onOk={addOrEditAddressModalOk}
        currentAddressItem={currentAddressItem}
      />
    </div>
  );
};
export default AddressManage;
