import React, { useEffect, useState } from 'react';
import { store } from '~/store';
import { InterDataType } from '~/api/interface';
import { SystemManageAPI } from '~/api';
import { getCompanyInfoByIdType } from '~/api/interface/systemManageType';
import './index.scss';
import StoreFormView from '~/pages/resourceManage/storeDecorate/comp/storeFormView';
import { Tabs, TabsProps } from 'antd';
import StoreSolutionView from '~/pages/resourceManage/storeDecorate/comp/storeSolutionView';
import StoreBusinessCase from '~/pages/resourceManage/storeDecorate/comp/storeBusinessCase';
import StoreDescView from '~/pages/resourceManage/storeDecorate/comp/StoreDescView';

// 店铺类型
type StoreType = InterDataType<getCompanyInfoByIdType>;

const StoreDecoratePage: React.FC = () => {
  const [storeDetail, setStoreDetail] = useState<StoreType>();
  // 获取店铺数据
  const getStoreApplyDetail = async () => {
    const res = await SystemManageAPI.getCompanyInfoById({
      id: store.getState().UserInfo.userInfo?.companyInfoVO?.id,
    });
    if (res && res.code === '200') {
      setStoreDetail(res.result);
      // console.log('获取店铺数据 --->', res.result);
    }
  };
  // 获取tab栏数据
  const getTabList = (): TabsProps['items'] => {
    if (!storeDetail?.id) return;
    let list = [
      {
        label: '基本信息',
        key: '1',
        children: <StoreFormView detail={storeDetail} onRefresh={getStoreApplyDetail} />,
      },
      {
        label: '企业介绍',
        key: '4',
        children: <StoreDescView detail={storeDetail} onRefresh={getStoreApplyDetail} />,
      },
    ];
    // 飞手团队特有
    if (storeDetail?.cooperationTagId === 5) {
      list = [
        ...list,
        {
          label: '解决方案',
          key: '2',
          children: <StoreSolutionView detail={storeDetail} />,
        },
      ];
    }
    // 产品商城特有
    if (storeDetail?.cooperationTagId === 1) {
      list = [
        ...list,
        {
          label: '业务案例',
          key: '3',
          children: <StoreBusinessCase detail={storeDetail} />,
        },
      ];
    }
    // 排序
    return list?.sort((a, b) => Number(a.key) - Number(b.key));
  };
  // 页面挂载
  useEffect(() => {
    if (store.getState().UserInfo?.userInfo?.companyInfoVO?.id) getStoreApplyDetail().then();
    // console.log('页面挂载 --->', store.getState().UserInfo?.userInfo);
  }, []);
  return (
    <div className={'store-decorate-wrap'}>
      {!!storeDetail?.id && <Tabs items={getTabList()} />}
    </div>
  );
};

export default StoreDecoratePage;
