import SearchBox, { searchColumns } from '~/components/search-box';
import { Button, Table } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
import { useState } from 'react';
import AddOrEditTagModal from './components/addOrEditTagModal';
//行业新闻
const TagManage = () => {
  const searchColumnsData: searchColumns[] = [
    {
      label: '标签名称',
      placeholder: '请输入标签名称',
      name: '',
      type: 'input',
    },
  ];
  const tableColumns: ColumnsType<any> = [
    {
      title: '序号',
      align: 'center',
    },
    {
      title: '标签名称',
      align: 'center',
    },
    {
      title: '标签类型',
      align: 'center',
    },
    {
      title: '标签等级图标',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
      render: () => (
        <>
          <Button type='link'>编辑</Button>
          <Button type='link'>删除</Button>
        </>
      ),
    },
  ];
  const [tableData, setTableData] = useState<any>([{ id: 1 }]);
  const [addOrEditTagModalShow, setAddOrEditTagModalShow] = useState<boolean>(false);

  const addOrEditTagClick = () => {
    setAddOrEditTagModalShow(true);
  };
  const addOrEditTagModalCancel = () => {
    setAddOrEditTagModalShow(false);
  };
  return (
    <div className='tag-manage'>
      <SearchBox
        search={searchColumnsData}
        child={
          <Button type='primary' icon={<PlusOutlined />} onClick={addOrEditTagClick}>
            新建
          </Button>
        }
      />
      <Table bordered columns={tableColumns} dataSource={tableData} rowKey='id'></Table>
      <AddOrEditTagModal open={addOrEditTagModalShow} onCancel={addOrEditTagModalCancel} />
    </div>
  );
};
export default TagManage;
