import {
  insertBAccountType,
  listBAccountPageType,
  removeBAccountType,
  updateBAccountType,
  updatePasswordType,
} from '../interface/systemManageType';
import axios from '../request';

export class SystemManageAPI {
  // 账号-列表
  static listBAccountPage: listBAccountPageType = (params) =>
    axios.post('/userapp/back-user/listBAccountPage', params);

  // 账号-新增
  static insertBAccount: insertBAccountType = (params) =>
    axios.post('/userapp/back-user/insertBAccount', params);

  // 账号-删除
  static removeBAccount: removeBAccountType = (params) =>
    axios.get('/userapp/user-account/removeAppAccount', { params });

  // 账号-修改
  static updateBAccount: updateBAccountType = (params) =>
    axios.post('/userapp/back-user/updateBAccount', params);

  // 账号-修改密码
  static updatePassword: updatePasswordType = (params) =>
    axios.post('/userapp/back-user/updatePassword', params);
}
