import { FC } from 'react';
import { Modal, ModalProps, Image } from 'antd';

type selfProps = {
  type: 'video' | 'image';
  url: string;
};

const PreviewImageVideo: FC<ModalProps & selfProps> = ({ open, type, url, onCancel }) => {
  return (
    <Modal open={open} onCancel={onCancel} footer={null} title='预览'>
      {type === 'video' ? (
        <video src={url} style={{ width: '100%', height: '200px' }} controls />
      ) : (
        ''
      )}
      {type === 'image' ? <Image src={url} width={100} height={100} /> : ''}
    </Modal>
  );
};
export default PreviewImageVideo;
