import { FC, useState } from 'react';
import { Button, Col, Form, Input, Modal, Row, Select, Upload } from 'antd';
import { ModalProps } from 'antd';
import { UploadOutlined } from '@ant-design/icons';
import { Uploader } from '~/components/uploader';
import { InterDataType, InterReqType } from '~/api/interface';
import { categoryListType } from '~/api/interface/categoryManage';
import { addServiceType } from '~/api/interface/mallManageType';

//分类返回类型
type categoryType = InterDataType<categoryListType>['list'];
interface selfProps {
  industryCategoryList: categoryType;
  applicationCategoryList: categoryType;
}
//新增服务参数类型
type addServiceParametersType = InterReqType<addServiceType>;

const AddOrEditServiceModal: FC<ModalProps & selfProps> = ({
  open,
  title,
  onCancel,
  industryCategoryList,
  applicationCategoryList,
}) => {
  const [form] = Form.useForm<addServiceParametersType>();
  //封面图文件
  const [coverPlanFileList, setCoverPlanFileList] = useState<
    {
      id: number;
      name: string;
      uid: number;
      url: string;
    }[]
  >([]);
  //分享卡片文件
  const [shareCardFileList, setShareCardFileList] = useState<
    {
      id: number;
      name: string;
      uid: number;
      url: string;
    }[]
  >([]);
  //视频上传文件
  const [videoFileList, setVideoFileList] = useState<
    {
      id: number;
      name: string;
      uid: number;
      url: string;
    }[]
  >([]);

  //封面图上传成功
  const coverPlanUploadSuccess = (
    fileList: {
      id: number;
      name: string;
      uid: number;
      url: string;
    }[],
  ) => {
    form.setFieldsValue({
      coverPlan: fileList[0].url,
    });
    setCoverPlanFileList(fileList);
  };
  //分享卡片上传成功
  const shareCardUploadSuccess = (
    fileList: {
      id: number;
      name: string;
      uid: number;
      url: string;
    }[],
  ) => {
    form.setFieldsValue({
      shareCard: fileList[0].url,
    });
    setShareCardFileList(fileList);
  };
  //视频上传成功
  const videoUploadSuccess = (
    fileList: {
      id: number;
      name: string;
      uid: number;
      url: string;
    }[],
  ) => {
    form.setFieldsValue({
      video: fileList[0].url,
    });
    setVideoFileList(fileList);
  };
  return (
    <Modal open={open} title={title} onCancel={onCancel}>
      <Form
        labelCol={{ span: 4 }}
        wrapperCol={{ span: 16 }}
        form={form}
        initialValues={{ displayState: 0 }}
      >
        <Form.Item
          label='服务名称'
          name='serviceName'
          rules={[{ required: true, message: '请输入服务名称' }]}
        >
          <Input placeholder='请输入服务名称' />
        </Form.Item>
        <Form.Item
          label='应用'
          name='applicationId'
          rules={[{ required: true, message: '请选择应用' }]}
        >
          <Select placeholder='请选择应用'>
            {applicationCategoryList.map((v) => (
              <Select.Option key={v.id} value={v.id}>
                {v.classifyName}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
        <Form.Item
          label='对应行业'
          name='industryId'
          rules={[{ required: true, message: '请选择对应行业' }]}
        >
          <Select placeholder='请选择对应行业'>
            {industryCategoryList.map((v) => (
              <Select.Option value={v.id} key={v.id}>
                {v.classifyName}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
        <Form.Item
          label='封面图'
          name='coverPlan'
          rules={[{ required: true, message: '请上传封面图' }]}
        >
          <Uploader listType='picture-card' fileUpload onChange={coverPlanUploadSuccess}>
            <UploadOutlined />
          </Uploader>
        </Form.Item>
        <Form.Item label='分享卡片' name='shareCard'>
          <Uploader listType='picture-card' fileUpload onChange={shareCardUploadSuccess}>
            <UploadOutlined />
          </Uploader>
        </Form.Item>
        <Form.Item label='视频' name='video'>
          <Row>
            <Col></Col>
            <Col>
              <Uploader
                listType='text'
                fileUpload
                onChange={videoUploadSuccess}
                fileType={['video/mp4', 'video/avi', 'video/wmv', 'video/rmvb']}
              >
                <Button icon={<UploadOutlined />} size='small' type='primary'>
                  上传
                </Button>
              </Uploader>
            </Col>
          </Row>
        </Form.Item>
        <Form.Item label='展示状态' name='displayState'>
          <Select placeholder='请选择展示状态'>
            <Select.Option value={0}>上架</Select.Option>
            <Select.Option value={1}>下架</Select.Option>
          </Select>
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default AddOrEditServiceModal;
