import { FC } from 'react';
import { Form, Input, Modal, ModalProps } from 'antd';

interface selfProps {
  onCancel: () => void;
  onOk: () => void;
}

const AddOrEditModal: FC<ModalProps & selfProps> = ({ open, onCancel, onOk }) => {
  const handleCancel = () => {
    onCancel();
  };
  const handleOk = () => {
    onOk();
  };

  return (
    <Modal title='新增分类' open={open} onCancel={handleCancel} onOk={handleOk}>
      <Form>
        <Form.Item label='分类名称'>
          <Input placeholder='请输入分类名称' />
        </Form.Item>
        <Form.Item label='分类图标'></Form.Item>
        <Form.Item label='分类描述'></Form.Item>
      </Form>
    </Modal>
  );
};
export default AddOrEditModal;
