import {
  addType,
  getTypeListType,
  rentTypeEditType,
  rentTypeRemoveType,
} from '~/api/interface/rentManageType';
import axios from '../request';

export class RentManageAPI {
  //租赁-新增类型
  static addTypeReq: addType = (data) => axios.post('/pms/attribute/addType', data);
  //租赁-类型列表
  static getTypeList: getTypeListType = (params) =>
    axios.get('/pms/attribute/typeList', { params });
  //  租赁-编辑类型
  static editTypeReq: rentTypeEditType = (data) => axios.post('/pms/attribute/editType', data);
  //  租赁-删除
  static rentTypeRemove: rentTypeRemoveType = (params) =>
    axios.get('/pms/attribute/removeType', { params });
}
