import './index.scss';
import { useEffect, useState } from 'react';
import * as echarts from 'echarts';
import { Progress } from 'antd';
import { DataDashboardsAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { userJoinReportDataType } from '~/api/interface/dataDashboardsType';
// 数据看板-加盟返回类型
type joinReportDataType = InterDataType<userJoinReportDataType>;
const JoinInfo = () => {
  const [joinReportDataType, setJoinReportDataType] = useState<joinReportDataType>();

  // 数据看板-加盟信息
  const getUserJoinReportData = () => {
    DataDashboardsAPI.getUserJoinReportData().then(({ result }) => {
      if (result) {
        setJoinReportDataType(result);
      }
    });
  };
  // 初始化饼图
  const initEchartsPie = () => {
    const myChart = echarts.init(document.getElementById('pie'));
    myChart.setOption({
      tooltip: {
        trigger: 'item',
      },
      series: [
        {
          type: 'pie',
          radius: ['40%', '70%'],
          avoidLabelOverlap: false,
          itemStyle: {
            normal: {
              color: function (params: any) {
                const colorList = ['#FF4100', '#6600FF', '#006BFF', '#FF9E00', '#64C9C9'];
                return colorList[params.dataIndex];
              },
            },
          },
          data: [
            { value: 40, name: '品牌商' },
            { value: 38, name: '维修商' },
            { value: 32, name: '培训机构' },
            { value: 30, name: '服务商' },
            { value: 28, name: '租赁商' },
          ],
        },
      ],
    });
    window.addEventListener('resize', function () {
      myChart.resize();
    });
  };

  useEffect(() => {
    initEchartsPie();
    getUserJoinReportData();
  }, []);
  return (
    <div className='join-info'>
      <div className='join-info-card-1'>
        <div className='join-count'>{joinReportDataType?.joinStoreCount}</div>
        <div className='join-meta'>入驻商家总数</div>
      </div>
      <div className='join-info-card-2'>
        <div className='card-header'>
          <div className='card-header-icon'></div>
          <div className='card-header-title'>入驻商家</div>
        </div>
        <div className='card-echarts' id='pie'></div>
      </div>
      <div className='join-info-card-3'>
        <div className='card-header'>
          <div className='card-header-icon'></div>
          <div className='card-header-title'>上架商品 (SKU)</div>
          <div className='sku-count'>2400</div>
        </div>
        <div className='card-progress'>
          <div className='progress-item'>
            <div className='progress-item-label'>售卖商品</div>
            <div className='progress-item-info'>
              <Progress percent={30} strokeColor='#F4872A' showInfo={false} />
            </div>
            <div className='progress-item-value'>122</div>
          </div>
          <div className='progress-item'></div>
          <div className='progress-item'></div>
        </div>
      </div>
    </div>
  );
};
export default JoinInfo;
