import axios from '../request';
import {
  couponDetailExportType,
  couponDetailType,
  CouponGetDataType,
  CouponIncreaseType,
  CouponPageListType,
  CouponSaveType,
  CouponShutDownType,
  SplitCouponAddType,
  SplitCouponListType,
} from '~/api/interface/couponManage';

export class CouponManageAPI {
  //  优惠券管理-裂变优惠券列表
  static getPageActivityList: SplitCouponListType = (data) => {
    return axios.post('userpay/coupon/back/pageActivityList', data);
  };

  //  优惠券管理-裂变优惠券新建
  static saveActivity: SplitCouponAddType = (data) => {
    return axios.post('userpay/coupon/back/saveActivity', data);
  };

  //  优惠券管理-裂变优惠券新建
  static CouponPageList: CouponPageListType = (data) => {
    return axios.post('userpay/coupon/back/pageList', data);
  };

  // 优惠券明细
  static getCouponDetail: couponDetailType = (data) => {
    return axios.post('userpay/coupon/back/getUserCouponList', data);
  };

  // 优惠券明细-导出
  static downloadCouponUserList: couponDetailExportType = (data) => {
    return axios.post('userpay/coupon/back/downloadCouponUserList', data, {
      responseType: 'blob',
    });
  };

  // 新增优惠券
  static CouponSave: CouponSaveType = (data) => {
    return axios.post('/userpay/coupon/back/save', data, {
      headers: { 'Content-Type': 'multipart/form-data' },
    });
  };

  // 增发优惠券
  static CouponIncrease: CouponIncreaseType = (params) => {
    return axios.post('/userpay/coupon/back/increase', {}, { params });
  };

  // 获取优惠券详情
  static CouponGetData: CouponGetDataType = (params) => {
    return axios.get('/userpay/coupon/back/getData', { params });
  };

  // 关闭优惠券
  static CouponShutDown: CouponShutDownType = (params) => {
    return axios.post('/userpay/coupon/back/shutDown', {}, { params });
  };
}
