import {
  addRentGoodsType,
  addRentModeType,
  addType,
  batchRemoveWareInfoType,
  deleteBrandInfoType,
  deleteModeType,
  editBrandInfoType,
  editLeaseGoodsType,
  editRentModeType,
  getTypeListType,
  leaseGoodsDetailsType,
  leaseGoodsListType,
  leaseTermInfoType,
  listBrandInfoType,
  otherServiceType,
  rentMakeAddType,
  rentModeListType,
  rentTypeEditType,
  rentTypeRemoveType,
} from '~/api/interface/rentManageType';
import axios from '../request';
import { batchOnShelfOrTakeDownType } from '~/api/interface/goodsType';

export class RentManageAPI {
  //租赁-类型-新增
  static addTypeReq: addType = (data) => axios.post('/pms/attribute/addType', data);
  //租赁-类型-列表
  static getTypeList: getTypeListType = (params) =>
    axios.get('/pms/attribute/typeList', { params });
  //  租赁-类型-编辑
  static editTypeReq: rentTypeEditType = (data) => axios.post('/pms/attribute/editType', data);
  //  租赁-类型-删除
  static rentTypeRemove: rentTypeRemoveType = (params) =>
    axios.get('/pms/attribute/removeType', { params });

  //  租赁-品牌-新增
  static addBrandInfo: rentMakeAddType = (params) =>
    axios.get('/pms/brand/addBrandInfo', { params });
  //  租赁-品牌-编辑
  static editBrandInfo: editBrandInfoType = (params) =>
    axios.get('/pms/brand/editBrandInfo', { params });
  //   租赁-品牌-列表
  static getListBrandInfo: listBrandInfoType = (params) =>
    axios.get('/pms/brand/listBrandInfo', { params });
  //   租赁-品牌-删除
  static deleteBrandInfo: deleteBrandInfoType = (params) =>
    axios.get('/pms/brand/deleteBrandInfo', { params });

  //  租赁-型号-新增
  static addRentMode: addRentModeType = (data) => axios.post('/pms/brand/addMode', data);
  //租赁-型号-编辑
  static editRentMode: editRentModeType = (data) => axios.post('/pms/brand/editMode', data);
  //租赁-型号-删除
  static deleteMode: deleteModeType = (params) => axios.get('/pms/brand/deleteMode', { params });
  //  租赁-型号-列表
  static getRentModeList: rentModeListType = (data) => axios.post('/pms/brand/modeList', data);

  //  租赁-商品-新增
  static addRentGoods: addRentGoodsType = (data) =>
    axios.post('/pms/lease/goods/addLeaseGoods', data);
  //租赁-商品-列表
  static getLeaseGoodsList: leaseGoodsListType = (data) =>
    axios.post('/pms/lease/goods/leaseGoodsList', data);
  //租赁-商品-编辑
  static editLeaseGoods: editLeaseGoodsType = (data) =>
    axios.post('/pms/lease/goods/editLeaseGoods', data);
  //租赁-商品-详情
  static getLeaseGoodsDetails: leaseGoodsDetailsType = (params) =>
    axios.get('/pms/lease/goods/leaseGoodsDetails', { params });
  //  租赁-商品-租期信息
  static getLeaseTermInfo: leaseTermInfoType = () =>
    axios.post('/pms/lease/goods/getLeaseTermInfo');
  //租赁-商品-上下架-批量
  static batchOnShelfOrTakeDown: batchOnShelfOrTakeDownType = (data) =>
    axios.post('/pms/lease/goods/batchOnShelfOrTakeDown', data);
  ////租赁-商品-删除-批量
  static batchRemoveWareInfo: batchRemoveWareInfoType = (data) =>
    axios.post('/pms/lease/goods/batchRemoveWareInfo', data);
  //  商品-其它服务列表
  static getOtherServiceList: otherServiceType = () => {
    return axios.get('/pms/goods/listOtherService');
  };
}
