import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  userInfo: JSON.parse(localStorage.getItem('SXTB-ADMIN-USER-INFO') as string) || [],
  roleId: -1,
  roleList: [],
};

export const userInfoSlice = createSlice({
  name: 'userInfo',
  initialState,
  reducers: {
    SET_USERINFO(state, action) {
      state.userInfo = action.payload;
      localStorage.setItem('SXTB-ADMIN-USER-INFO', JSON.stringify(action.payload));
    },
    SET_ROLE_ID(state, action) {
      state.roleId = action.payload;
      localStorage.setItem('roleId', action.payload);
    },
    SET_ROLE_LIST(state, action) {
      state.roleList = action.payload;
      localStorage.setItem('roleObj', JSON.stringify(action.payload));
    },
    REMOVE_ROLE_LIST() {
      localStorage.removeItem('roleObj');
    },
  },
});

export const { SET_USERINFO, SET_ROLE_ID, SET_ROLE_LIST, REMOVE_ROLE_LIST } = userInfoSlice.actions;

export const UserInfo = userInfoSlice.reducer;
