import '@wangeditor/editor/dist/css/style.css'; // 引入 css
import React, { useState, useEffect } from 'react';
import { Editor, Toolbar } from '@wangeditor/editor-for-react';
import { IDomEditor, IEditorConfig, IToolbarConfig, InsertFnType } from '@wangeditor/editor';
import { message } from 'antd';
import { CommonAPI } from '~/api';

interface PropsType {
  onChange?: (html?: string) => void;
  value: string | undefined;
  // eslint-disable-next-line react/require-default-props
  isDetail?: boolean; //是否禁用
  height?: number;
  imgSize?: number;
  videoSize?: number;
}
const RichText: React.FC<PropsType> = ({
  onChange,
  value,
  isDetail,
  height,
  imgSize,
  videoSize,
}) => {
  // editor 实例
  const [editor, setEditor] = useState<IDomEditor | null>(null);

  // 编辑器内容
  const [html, setHtml] = useState<string>('');

  // 工具栏配置
  const toolbarConfig: Partial<IToolbarConfig> = {};

  // 编辑器配置
  const editorConfig: Partial<IEditorConfig> = {
    // TS 语法
    placeholder: '请输入内容...',
    MENU_CONF: {
      uploadImage: {
        // 自定义上传
        async customUpload(file: File, insertFn: InsertFnType) {
          if (file.size / 1024 / 1024 > (imgSize || 5)) {
            return message.warning(`上传文件大小最大${imgSize || 5}M`);
          }
          if (!file.type.includes('image/')) {
            return message.warning('文件格式错误');
          }
          const formData = new FormData();
          formData.append('uploadFile', file);
          CommonAPI.uploadOss(formData).then(({ result }) => {
            insertFn(result.filePath);
          });
        },
      },
      uploadVideo: {
        // 自定义上传
        async customUpload(file: File, insertFn: InsertFnType) {
          if (file.size / 1024 / 1024 > (videoSize || 5)) {
            return message.warning(`上传文件大小最大${videoSize || 5}M`);
          }
          if (!file.type.includes('video/')) {
            return message.warning('文件格式错误');
          }
          const formData = new FormData();
          formData.append('uploadFile', file);
          CommonAPI.uploadOss(formData).then(({ result }) => {
            insertFn(result.filePath);
          });
        },
      },
    },
  };
  //富文本修改
  const richTextChange = (editor: IDomEditor) => {
    setHtml(editor.getHtml());
    if (onChange) {
      onChange(editor.getHtml() || '');
    }
  };
  // 及时销毁 editor ，重要！
  useEffect(() => {
    return () => {
      if (editor == null) return;
      editor.destroy();
      setEditor(null);
    };
  }, [editor]);

  useEffect(() => {
    setHtml(value || '');
  }, [value]);

  useEffect(() => {
    if (editor && isDetail) {
      editor.disable();
    }
  }, [isDetail]);

  return (
    <>
      <div style={{ border: '1px solid #ccc', zIndex: 100 }}>
        <Toolbar
          editor={editor}
          defaultConfig={toolbarConfig}
          mode='default'
          style={{ borderBottom: '1px solid #ccc' }}
        />
        <Editor
          defaultConfig={editorConfig}
          value={html}
          onCreated={setEditor}
          onChange={richTextChange}
          mode='default'
          style={{ height: height || 500 + 'px', overflowY: 'hidden' }}
        />
      </div>
    </>
  );
};
export default RichText;
