import SearchBox, { searchColumns } from '~/components/search-box';
import { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import { Button, Card, Table } from 'antd';
import {
  ArrowDownOutlined,
  ArrowUpOutlined,
  DeleteOutlined,
  PlusOutlined,
} from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
const GoodsList = () => {
  const navigate = useNavigate();
  const tabList = [
    {
      key: '1',
      tab: '全部',
    },
    {
      key: '2',
      tab: '上架中',
    },
    {
      key: '3',
      tab: '仓库中',
    },
  ];
  const [activeTabKey, setActiveTabKey] = useState<string>('1');
  const [searchColumns] = useState<searchColumns[]>([
    {
      label: '商品名称',
      placeholder: '请输入商品名称',
      name: '',
      type: 'input',
    },
    {
      label: '所属目录',
      placeholder: '请选择所属目录',
      name: '',
      type: 'select',
      options: [],
    },
    {
      label: '创建时间',
      placeholder: '请输入选择创建时间',
      name: '',
      type: 'rangePicker',
    },
  ]);
  const tableColumns: ColumnsType<any> = [
    { title: '序号', align: 'center' },
    { title: '图片', align: 'center' },
    { title: '商品名称', align: 'center' },
    { title: '所属目录', align: 'center' },
    { title: '创建时间', align: 'center' },
    { title: '状态', align: 'center' },
    {
      title: '操作',
      align: 'center',
      render: () => (
        <>
          <Button type='link' onClick={toEditGoods}>
            编辑
          </Button>
          <Button type='link'>详情</Button>
        </>
      ),
    },
  ];
  const [tableData] = useState<{ id: number }[]>([{ id: 1 }]);

  const onTabChange = (key: string) => {
    setActiveTabKey(key);
  };
  //新增商品
  const toAddMallGoods = () => {
    navigate({ pathname: '/mallManage/mallGoods/add' });
  };
  //编辑商品
  const toEditGoods = () => {
    navigate({
      pathname: '/mallManage/mallGoods/add',
      search: `id=${43}`,
    });
  };
  return (
    <div className='goods-list'>
      <SearchBox
        search={searchColumns}
        child={
          <Button type='primary' icon={<PlusOutlined />} onClick={toAddMallGoods}>
            新增商品
          </Button>
        }
      />
      <Card tabList={tabList} activeTabKey={activeTabKey} onTabChange={onTabChange}>
        <div className='header-operate' style={{ marginBottom: '10px' }}>
          <Button type='primary' style={{ marginRight: '10px' }} icon={<ArrowUpOutlined />}>
            上架
          </Button>
          <Button type='primary' style={{ marginRight: '10px' }} icon={<ArrowDownOutlined />}>
            下架
          </Button>
          <Button danger icon={<DeleteOutlined />}>
            删除
          </Button>
        </div>
        <Table columns={tableColumns} bordered dataSource={tableData} />
      </Card>
    </div>
  );
};
export default GoodsList;
