import React, { useEffect, useState } from 'react';
import { Checkbox, Form } from 'antd';
import './index.scss';
import GoodsAPI from '~/api/modules/goodsAPI';
import { detailGoodsType, otherServiceType } from '~/api/interface/goodsType';
import { InterDataType } from '~/api/interface';
//商品返回类型
type goodsDetailType = InterDataType<detailGoodsType>;

interface selfProps {
  otherServiceSelect: (id: number[]) => void;
  goodsDetail: goodsDetailType | undefined;
}
//其它服务返回类型
type otherServiceListType = InterDataType<otherServiceType>;

const OtherInfo: React.FC<selfProps> = ({ otherServiceSelect, goodsDetail }) => {
  //其它服务
  const [otherServiceList, setOtherServiceList] = useState<otherServiceListType>([]);
  const otherServiceRadioChange = (e: any) => {
    otherServiceSelect(e);
  };
  //获取其它服务
  const getOtherServiceList = () => {
    GoodsAPI.getOtherServiceList().then(({ result }) => {
      setOtherServiceList(result);
    });
  };

  useEffect(() => {
    getOtherServiceList();
  });
  return (
    <div className='other-info'>
      <div className='other-info-title'>其它信息</div>
      <div className='other-info-form'>
        <Form>
          <Form.Item label='搭配服务' name='otherService'>
            <Checkbox.Group
              onChange={otherServiceRadioChange}
              value={goodsDetail?.otherService || []}
            >
              {otherServiceList.map((item: any, index: number) => (
                <Checkbox value={item.id} key={index}>
                  {item.saleServiceName}
                </Checkbox>
              ))}
            </Checkbox.Group>
          </Form.Item>
        </Form>
      </div>
    </div>
  );
};

export default OtherInfo;
