import { InterFunction, InterListFunction } from '~/api/interface';
// V1.0.1课程视频列表
export type queryCurriculumInfoListType = InterListFunction<
  {
    curriculumName?: string;
    flightSkillsId?: number;
    licenseId?: number;
    regionId?: number;
  },
  {
    curriculumDesc: string;
    curriculumName: string;
    detailContent: null;
    flightSkills: number;
    flightSkillsName1: string;
    flightSkillsName2: string;
    free: number;
    id: number;
    price: null;
    supplierName: string;
    surfaceUrl: null;
    videoUrl: string;
  }
>;
// V1.0.1新增课程
export type addCurriculumType = InterFunction<
  {
    curriculumDesc?: string;
    curriculumName?: string;
    detailContent?: string;
    flightSkills?: number;
    flightSkillsName1?: string;
    flightSkillsName2?: string;
    free?: number;
    id?: number | null;
    price?: number;
    supplierName?: string;
    surfaceUrl?: string;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// V1.0.1修改课程
export type updateCurriculumType = InterFunction<
  {
    curriculumDesc?: string;
    curriculumName?: string;
    detailContent?: string;
    flightSkills?: number;
    flightSkillsName1?: string;
    flightSkillsName2?: string;
    free?: number;
    id: number | null;
    price?: number;
    supplierName?: string;
    surfaceUrl?: string;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// V1.0.1课程技能列表
export type treeCurriculumSkillType = InterFunction<
  NonNullable<unknown>,
  {
    id: number;
    skillsName: string;
    flightSkills: Array<{
      id: number;
      skillsName: string;
      flightSkills: null;
    }>;
  }[]
>;
// V1.0.1删除课程
export type removeCurriculumType = InterFunction<{ id: number }, NonNullable<unknown>>;
