import React, { useEffect, useState } from 'react';
import { Image, Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { InterDataType } from '~/api/interface';
import { mallOrderDetailType } from '~/api/interface/orderManageType';
import './index.scss';
import { OrderManageAPI } from '~/api';

// 接口返回的类型
type DataType = InterDataType<mallOrderDetailType>;
// 参数类型
type PropsType = {
  detail: DataType | undefined;
};

const DetailInformation: React.FC<PropsType> = (props) => {
  const { detail } = props;
  // 表格结构
  const columns: ColumnsType<DataType['skuDTOList'][0]> = [
    {
      title: '商品',
      align: 'center',
      width: '20%',
      render: (_text, record) => (
        <div className='mall-sku-item'>
          <Image src={record.skuImage} className='sku-img' />
          <div className='sku-info'>
            <div className='info-name'>{record.tradeName}</div>
            <div className='info-spec'>
              {Object.entries(JSON.parse(record.productSpec)).map((v, index) => (
                <span key={index}>{v.join('：')}</span>
              ))}
            </div>
          </div>
        </div>
      ),
    },
    {
      title: '单价（元）',
      dataIndex: 'unitPrice',
      align: 'center',
      render: (text) => `￥${text?.toLocaleString()}`,
    },
    {
      title: '数量',
      dataIndex: 'orderNum',
      align: 'center',
    },
    {
      title: '订单状态',
      align: 'center',
      render: () => orderStatusList.find((v) => v.value === detail?.statusCode)?.label,
    },
    {
      title: '订单金额（元）',
      align: 'center',
      render: () => `￥${detail?.orderTotalAmount}`,
    },
  ];
  // 订单状态
  const [orderStatusList, setOrderStatusList] = useState<{ value: number; label: string }[]>([]);

  // 获取订单状态
  const getOrderStatus = () => {
    OrderManageAPI.getMallOrderStatusList().then(({ result }) => {
      if (result) {
        const list = result.map((item) => ({ value: item.code, label: item.status }));
        setOrderStatusList(list);
      }
    });
  };

  useEffect(() => {
    getOrderStatus();
  }, []);
  return (
    <div className='detail-information'>
      <div className='detail-title'>订单明细</div>
      <div className='detail-text'>
        <span className='item'>订单编号：{detail?.orderNo}</span>
        <span className='item'>创建时间：{detail?.createTime}</span>
      </div>
      <Table
        size='small'
        dataSource={detail?.skuDTOList || []}
        columns={columns}
        rowKey='id'
        bordered
        pagination={false}
        // rowSelection={{ selectedRowKeys, onChange: onSelectChange }}
      />
    </div>
  );
};

export default DetailInformation;
