import './assets/style/App.scss';
import PrivateRouter from '~/router/privateRouter';
import { BrowserRouter } from 'react-router-dom';
import { useEffect } from 'react';

const App = () => {
  const resizeListener = () => {
    // 定义设计图的尺寸 3840
    const designSize = 1920;
    // 获取 html 元素
    const html = document.documentElement;
    // 定义窗口的宽度
    const clientW = html.clientWidth;
    // html 的fontsize 大小
    const htmlRem = (clientW * 12) / designSize;
    html.style.fontSize = htmlRem + 'px';
  };

  useEffect(() => {
    window.addEventListener('resize', resizeListener);
    resizeListener();
  }, []);
  return (
    <>
      <BrowserRouter>
        <PrivateRouter />
      </BrowserRouter>
    </>
  );
};

export default App;
