import React, { Suspense } from 'react';
import { Layout, Space } from 'antd';
import { Outlet } from 'react-router-dom';
import NavHeader from '~/components/NavHeader';
import FooterView from '~/components/footer';

const { Header, Footer, Content } = Layout;

const headerStyle: React.CSSProperties = {
  height: 'auto',
  background: 'none',
  padding: 0,
  lineHeight: '1'
};

const contentStyle: React.CSSProperties = {
  textAlign: 'center',
  minHeight: 120,
  lineHeight: '1',
  color: '',
  backgroundColor: '',
};

const footerStyle: React.CSSProperties = {
  textAlign: 'center',
  color: '',
  backgroundColor: '',
  lineHeight: '1',
  padding: 0
};

type Props = {
  children: React.ReactNode;
};

export default function LayoutView(props: Props) {
  return (
    <Space direction='vertical' style={{ width: '100%' }} size={[0, 48]}>
      <Layout style={{ minHeight: '100vh' }}>
        <Header style={headerStyle}>
          <NavHeader />
        </Header>
        <Content style={contentStyle}>
          {props.children}
          <Suspense fallback={<div>Loading...</div>}>
            <Outlet></Outlet>
          </Suspense>
        </Content>
        <Footer style={footerStyle}>
          <FooterView></FooterView>
        </Footer>
      </Layout>
    </Space>
  );
}
