// 分页通用接口
export interface PaginationProps {
  pageSize?: number;
  pageNo?: number;
}

// 通用返回接口(分页)
export interface ResponseListType<D> {
  code: string;
  message: string;
  result: {
    pageNo: number;
    pageSize: number;
    totalCount: number;
    totalPage: number;
    list: Array<D>;
  };
}

// 通用返回接口(分页了，但又没有分页)
export interface ResponseItemType<D> {
  code: string;
  message: string;
  result: {
    pageNo: number;
    pageSize: number;
    totalCount: number;
    totalPage: number;
    list: D;
  };
}

// 通用返回接口
export interface ResponseType<D> {
  code: string;
  message: string;
  result: D;
}

// 通用接口封装(分页) 不推荐
export interface InterListType<D, T> {
  req: D & PaginationProps;
  res: Promise<ResponseListType<T>>;
}

// 通用接口封装(不分页) 不推荐
export interface InterType<D, T> {
  req: D;
  res: Promise<ResponseType<T>>;
}

// 通用接口封装函数(分页) 建议用这个
export interface InterListFunction<D extends object, T> {
  (req: D & PaginationProps): Promise<ResponseListType<T>>;
}

// 通用接口封装函数(不分页) 建议用这个
export interface InterFunction<D extends object, T> {
  (req?: D): Promise<ResponseType<T>>;
}

// 通用接口封装函数(分页了，但又没有分页) 建议用这个
export interface InterItemFunction<D extends object, T> {
  (req: D & PaginationProps): Promise<ResponseItemType<T>>;
}
