import axios from '../request';
import {
  industryAddType,
  industryDeleteType,
  industryDetailType,
  industryEditType,
  industrySpecAdd,
  industrySpecDetailType,
  industrySpecList,
  listIndustryType,
  removeIndustrySpecType,
  editIndustrySpecType,
} from '~/api/interface/industryManageType';
export class IndustryManageAPI {
  // 行业列表
  static getIndustryList: listIndustryType = (data) => {
    return axios.post('/pms/industry/spec/listPageIndustrySku', data);
  };
  // 行业-新增
  static addIndustryRequest: industryAddType = (data) => {
    return axios.post('/pms/industry/spec/addIndustrySku', data);
  };

  // 行业---编辑
  static editIndustryRequest: industryEditType = (data) => {
    return axios.post('/pms/industry/spec/editIndustrySku', data);
  };

  // 行业--删除
  static removeIndustryRequest: industryDeleteType = (params) => {
    return axios.get('/pms/industry/spec/removeIndustrySku', { params });
  };

  // 行业-详情
  static getIndustryDetail: industryDetailType = (params) => {
    return axios.get('/pms/industry/spec/getIndustrySkuDetail', {
      params,
    });
  };
  // 行业-方案规格-列表
  static getIndustrySpecList: industrySpecList = (params) => {
    return axios.get('/pms/industry/spec/listPageIndustrySpec', {
      params,
    });
  };
  // 行业---方案规格管理---新增方案规格
  static addIndustrySpec: industrySpecAdd = (data) => {
    return axios.post('/pms/industry/spec/addIndustrySpec', data);
  };

  // 行业sku管理---方案规格管理---编辑行业规格
  static editIndustrySpec: editIndustrySpecType = (data) => {
    return axios.post('/pms/industry/spec/editIndustrySpec', data);
  };

  // 行业---方案规格管理---删除行业规格
  static removeIndustrySpec: removeIndustrySpecType = (params) => {
    return axios.get('/pms/industry/spec/removeIndustrySpec', { params });
  };

  // 行业sku管理---方案规格管理---获取价格配置信息  (获取价格配置)
  static getIndustrySpecCPQ = (params: unknown) => {
    return axios.get('uavgoods/industry/spec/getIndustrySpecCPQ', { params });
  };

  // 行业sku管理---方案规格管理---价格配置  (新增价格配置)
  static industrySpecCPQ = (data: unknown) => {
    return axios.post('uavgoods/industry/spec/industrySpecCPQ', data);
  };

  // 行业sku管理---方案规格管理---价格配置信息的修改 (修改价格配置)
  static updateIndustrySpecCPQ = (data: unknown) => {
    return axios.post('uavgoods/industry/spec/updateIndustrySpecCPQ', data);
  };

  // 行业sku管理---方案规格管理---单个方案规格回显 (查看产品清单)
  static getIndustrySpecDetail: industrySpecDetailType = (params) => {
    return axios.get('/pms/industry/spec/getIndustrySpecDetail', {
      params,
    });
  };
}
