import { InterFunction, InterListFunction } from '~/api/interface';

//论坛-列表
export type forumListType = InterListFunction<
  { keyword?: string; static?: number },
  {
    id: number;
    description: string;
    mediaVO: null;
    show: number;
    gambitName: string[];
    userBaseInfo: {
      nickName: string;
      userImg: string;
      userName: null;
      phone: string;
      uid: string;
    };
    userAccountId: number;
    dynamicPublishTime: string;
    checkStatus: 0 | 1 | 2;
  }
>;
//论坛-删除
export type deleteForumType = InterFunction<{ dynamicId: number }, any>;
//论坛-隐藏
export type hiddenForumType = InterFunction<{ dynamicId: number }, any>;
//论坛-详情
type detailResponseType = {
  userBaseInfo: {
    nickName: string;
    phone: string;
    uid: string;
    userImg: string;
    userName: string;
  };
  description: string;
  dynamicPublishTime: string;
  id: number;
  likes: boolean;
  likesCount: number;
  mediaVO: { type: number; url: string }[];
  commentCount: number;
  commentAndReplyVO: detailResponseType[];
};
export type forumDetailType = InterFunction<{ dynamicId: number }, detailResponseType>;
//论坛-点赞信息
export type likeUserInfoType = InterFunction<
  { dynamicId: number },
  { nickName: string; userImg: string; userName: string }[]
>;
// 论坛-审核
export type checkDynamicType = InterFunction<
  { dynamicId: number; status: boolean },
  NonNullable<unknown>
>;

// 话题-列表
export type listGambitType = InterListFunction<
  {
    /**
     * 话题名称
     */
    gambitName?: string;
    /**
     * 话题属性 1普通 2热门 3推荐
     */
    gambitProperty?: number;
  },
  {
    /**
     * 话题参与讨论数量
     */
    discussionCount?: number;
    /**
     * 话题封面
     */
    gambitCover?: string;
    /**
     * 话题图标
     */
    gambitIcon?: string;
    /**
     * 话题名称
     */
    gambitName?: string;
    /**
     * 话题属性
     */
    gambitProperty?: number;
    id: number;
    /**
     * 贴子数
     */
    postCount?: number;
  }
>;
// 话题-新增
export type addGambitType = InterFunction<
  {
    /**
     * 话题封面
     */
    gambitCover: string;
    /**
     * 话题图标
     */
    gambitIcon: string;
    /**
     * 话题名称
     */
    gambitName: string;
    /**
     * 话题属性 话题属性 1普通 2热门 3推荐
     */
    gambitProperty: number;
  },
  any
>;
// 话题-删除
export type deleteGambitType = InterFunction<{ id: number }, any>;
// 话题-编辑
export type updateGambitType = InterFunction<
  {
    /**
     * 话题封面
     */
    gambitCover: string;
    /**
     * 话题图标
     */
    gambitIcon: string;
    /**
     * 话题名称
     */
    gambitName: string;
    /**
     * 话题属性 话题属性 1普通 2热门 3推荐
     */
    gambitProperty: number;
    id?: number;
  },
  any
>;
// 话题-状态个数统计
export type countGambitType = InterFunction<
  any,
  {
    failAuditSum: number;
    passAuditSum: number;
    unAuditedSum: number;
  }
>;
