package com.mmc.pms.service.inspection.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.common.ResultEnum;
import com.mmc.pms.dao.inspection.CompanyInspectionDao;
import com.mmc.pms.dao.inspection.InspectionDao;
import com.mmc.pms.entity.inspection.InspectionDO;
import com.mmc.pms.model.inspection.dto.InspectionDTO;
import com.mmc.pms.model.inspection.vo.InspectionVO;
import com.mmc.pms.model.qo.CompanyInspectionQO;
import com.mmc.pms.model.qo.InspectionQO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.inspection.CompanyInspectionService;
import com.mmc.pms.service.inspection.InspectionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/8/4 16:31
 */
@Service
public class InspectionServiceImpl implements InspectionService {
    @Autowired
    private InspectionDao inspectionDao;

    @Autowired
    private CompanyInspectionDao companyInspectionDao;

    @Override
    public ResultBody insert(InspectionVO inspectionVO) {
        InspectionDO inspectionDO = new InspectionDO(inspectionVO);
        int count = inspectionDao.countSameName(inspectionVO.getId(), inspectionVO.getInspectionName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.INSPECTION_NAME_CREATE_ERROR);
        }
        inspectionDao.insert(inspectionDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody update(InspectionVO inspectionVO) {
        InspectionDO inspectionDO = new InspectionDO(inspectionVO);
        int count = inspectionDao.countSameName(inspectionVO.getId(), inspectionVO.getInspectionName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.INSPECTION_NAME_CREATE_ERROR);
        }
        inspectionDao.update(inspectionDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody remove(Integer id) {
        // 有绑定则不能删除
        CompanyInspectionQO companyInspectionQO = new CompanyInspectionQO();
        companyInspectionQO.setInspectionId(id);
        int count = companyInspectionDao.countListCompanyInspectionPage(companyInspectionQO);
        if (count > 0) {
            return ResultBody.error(ResultEnum.UNBINDING_ERROR_1);
        }
        inspectionDao.remove(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody<InspectionDTO> detail(Integer id) {
        InspectionDO inspectionDO = inspectionDao.getInspectionById(id);
        if (inspectionDO == null) {
            return ResultBody.success();
        }
        return ResultBody.success(inspectionDO.buildInspectionDTO());
    }

    @Override
    public ResultBody<InspectionDTO> listInspectionPages(InspectionQO inspectionQO) {
        int count = inspectionDao.countListInspectionPages(inspectionQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(inspectionQO.getPageNo(), inspectionQO.getPageSize(), count));
        }
        int pageNo = inspectionQO.getPageNo();
        inspectionQO.buildCurrentPage();
        List<InspectionDO> inspectionDOS = inspectionDao.listInspectionPages(inspectionQO);
        List<InspectionDTO> inspectionDTOS = inspectionDOS.stream().map(InspectionDO::buildInspectionDTO).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, inspectionQO.getPageSize(), count, inspectionDTOS));
    }
}
