package com.mmc.pms.model.lease.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small @Date 2023/5/16 9:54 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "设备图片DTO")
public class WareImgDTO implements Serializable {
  private static final long serialVersionUID = 1195966760401573468L;

  @ApiModelProperty(name = "图片ID", value = "图片ID", required = false, example = "图片ID")
  private Integer id;

  @ApiModelProperty(name = "商品ID", value = "商品ID", required = false, example = "商品ID")
  private Integer wareInfoId;

  @ApiModelProperty(
      name = "图片类型：0:主图 1:副图",
      value = "图片类型：0:主图 1:副图",
      required = false,
      example = "图片类型：0:主图 1:副图")
  private String imgUrl;

  @ApiModelProperty(name = "图片ID", value = "图片ID", required = false, example = "图片ID")
  private Integer imgType;
}
