package com.mmc.pms.model.categories.dto;


import com.mmc.pms.entity.Categories;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;

/**
 * @author lw
 * @TableName categories
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CategoriesDTO implements Serializable {

    private Integer id;

    @ApiModelProperty(value = "分类名称")
    private String name;

    @ApiModelProperty(value = "分类类型")
    private Integer type;

    public CategoriesDTO(Categories categories) {
        this.id = categories.getId();
        this.name = categories.getName();
        this.type = categories.getType();
    }
}