package com.mmc.pms.entity.mall;

import com.mmc.pms.model.mall.GoodsResourcesVO;
import com.mmc.pms.model.mall.MallGoodsVO;
import com.mmc.pms.model.mall.UavCartDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 商品基本信息(MallGoodsDO)实体类
 *
 * @author makejava
 * @since 2023-07-24 21:10:02
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MallGoodsDO implements Serializable {
    private static final long serialVersionUID = 709941898403563905L;

    private Integer id;
    /**
     * 商品编号(ID12345678)
     */
    private String goodsNo;
    /**
     * 商品名称
     */
    private String tradeName;
    /**
     * 商品描述
     */
    private String description;
    /**
     * 商品一级分类
     */
    private Integer categoryPrimaryId;
    /**
     * 商品二级分类
     */
    private Integer categorySubId;
    /**
     * 状态：0: 下架 1:上架
     */
    private Integer shelfStatus;
    /**
     * 商品标签
     */
    private String goodsLabel;
    /**
     * 标签是否显示0：否1：是
     */
    private Integer labelShow;
    /**
     * 商品详情图 富文本
     */
    private String goodsDetails;
    /**
     * 创建商品用户id
     */
    private Integer userAccountId;
    /**
     * 排序字段
     */
    private Integer sort;
    /**
     * 商品热度
     */
    private Integer hot;

    private Integer priceShow;

    private Date createTime;

    private Date updateTime;

    private Integer deleted;

    private Integer recommend;

    private String url;
    private Integer type;
    private Integer imgId;
    private List<MallGoodsDO> mallGoodsDOList;

    private List<PriceStockDO> priceStockDOS;

    /**
     * 关联话题id
     */
    private Integer gambitId;
    /**
     * 关于产品使用说明
     */
    private String instructionsUrl;

    public MallGoodsDO(MallGoodsVO mallGoodsVO) {
        this.id = mallGoodsVO.getId();
        this.tradeName = mallGoodsVO.getTradeName();
        this.description = mallGoodsVO.getDescription();
        this.categoryPrimaryId = mallGoodsVO.getCategoryPrimaryId();
        this.categorySubId = mallGoodsVO.getCategorySubId();
        this.shelfStatus = mallGoodsVO.getShelfStatus();
        this.goodsLabel = mallGoodsVO.getGoodsLabel();
        this.labelShow = mallGoodsVO.getLabelShow();
        this.priceShow = mallGoodsVO.getPriceShow();
        this.recommend = mallGoodsVO.getRecommend() == null ? 0 : mallGoodsVO.getRecommend();
        this.goodsDetails = mallGoodsVO.getGoodsDetails();
        this.gambitId = mallGoodsVO.getGambitId();
        this.instructionsUrl = mallGoodsVO.getInstructionsUrl();
    }

    public MallGoodsVO buildMallGoodsVO() {
        return MallGoodsVO.builder().id(id).userAccountId(userAccountId).tradeName(tradeName)
                .description(description).categoryPrimaryId(categoryPrimaryId).categorySubId(categorySubId)
                .shelfStatus(shelfStatus).priceShow(priceShow).goodsLabel(goodsLabel).labelShow(labelShow).gambitId(gambitId)
                .createTime(createTime).goodsDetails(goodsDetails).recommend(recommend).instructionsUrl(instructionsUrl).build();
    }

    public MallGoodsVO buildListMallGoodsVO() {
        List<GoodsResourcesVO> resourcesList = new ArrayList<>();
        GoodsResourcesVO goodsResourcesVO = new GoodsResourcesVO();
        goodsResourcesVO.setId(imgId);
        goodsResourcesVO.setUrl(url);
        goodsResourcesVO.setType(type);
        resourcesList.add(goodsResourcesVO);
        return MallGoodsVO.builder().id(id).userAccountId(userAccountId).recommend(recommend).tradeName(tradeName).resourcesList(resourcesList)
                .categoryPrimaryId(categoryPrimaryId).labelShow(labelShow).goodsLabel(goodsLabel).categorySubId(categorySubId)
                .shelfStatus(shelfStatus).createTime(createTime).priceStock(CollectionUtils.isEmpty(priceStockDOS) ? null : priceStockDOS.stream()
                        .map(PriceStockDO::buildPriceStockVO).collect(Collectors.toList())).description(description).priceShow(priceShow).build();
    }

    public UavCartDTO buildUavCartDTO() {
        return UavCartDTO.builder().mallGoodsId(id).thirdBackUserAccountId(userAccountId).tradeName(tradeName)
                .priceShow(priceShow).deleted(deleted).shelfStatus(shelfStatus).build();
    }
}

