package com.mmc.pms.entity.inspection;

import com.mmc.pms.model.inspection.dto.IndustryTypeDTO;
import com.mmc.pms.model.inspection.vo.IndustryTypeVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/8/3 16:23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IndustryTypeDO implements Serializable {
    private static final long serialVersionUID = -3416853218669751905L;
    private Integer id;
    /**
     * 行业类型名称
     */
    private String typeName;
    /**
     * 行业图标
     */
    private String typeImg;
    /**
     * 行业描述
     */
    private String description;
    /**
     * 售卖状态，0停售，1在售
     */
    private Integer saleState;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 服务列表
     */
    private List<InspectionDO> inspectionDOS;
    @ApiModelProperty(value = "二级服务分类名称")
    private String inspectionName;

    public IndustryTypeDO(IndustryTypeVO industryTypeVO) {
        this.id = industryTypeVO.getId();
        this.typeName = industryTypeVO.getTypeName();
        this.typeImg = industryTypeVO.getTypeImg();
        this.description = industryTypeVO.getDescription();
        this.saleState = industryTypeVO.getSaleState();
    }

    public IndustryTypeDTO buildIndustryTypeDTO(){
        return IndustryTypeDTO.builder().id(this.id).typeName(this.typeName).typeImg(this.typeImg)
                .description(this.description).saleState(this.saleState).createTime(this.createTime)
                .inspectionDTOS(CollectionUtils.isNotEmpty(this.inspectionDOS) ?
                        this.inspectionDOS.stream().map(InspectionDO::buildInspectionDTO).collect(Collectors.toList()) : null)
                .inspectionName(this.inspectionName)
                .build();
    }


}
