package com.mmc.pms.entity.category;

import com.mmc.pms.model.category.vo.ModeInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (DeviceModeDO)实体类
 *
 * @author makejava
 * @since 2023-08-10 11:26:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DeviceModeDO implements Serializable {
    private static final long serialVersionUID = -76818224092139310L;

    private Integer id;

    private Integer brandInfoId;

    private Integer productTypeId;

    private String modelName;

    private String tag;

    private Date createTime;

    private Date updateTime;

    public DeviceModeDO(ModeInfoVO param) {
        this.id = param.getId();
        this.brandInfoId = param.getBrandInfoId();
        this.productTypeId = param.getProductTypeId();
        this.modelName = param.getModeName();
        this.tag = param.getTag();
    }

    public ModeInfoVO buildModeInfoVO() {
        return ModeInfoVO.builder().id(id).productTypeId(productTypeId)
                .brandInfoId(brandInfoId).modeName(modelName).tag(tag).build();
    }
}

