package com.mmc.pms.dao.inspection;

import com.mmc.pms.entity.inspection.IndustryTypeDO;
import com.mmc.pms.entity.inspection.InspectionDO;
import com.mmc.pms.model.qo.IndustryTypeQO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/8/3 17:59
 */
@Mapper
public interface IndustryTypeDao {
    int countSameName(Integer id, String typeName);

    void insert(IndustryTypeDO industryTypeDO);

    void update(IndustryTypeDO industryTypeDO);

    void remove(Integer id);

    int countListPages(IndustryTypeQO industryTypeQO);

    List<IndustryTypeDO> listPages(IndustryTypeQO industryTypeQO);

    List<IndustryTypeDO> listIndustry();

    List<InspectionDO> listInspectionsByIndustryTypeIdId(Integer industryTypeId);

    IndustryTypeDO getIndustryTypeById(Integer id);

    /**
     * 获取二级分类的服务名称
     * @param inspectionId 二级服务的id
     * @return {@link String}
     */
    String getInspectionNameById(Integer inspectionId);
}
