package com.mmc.pms.controller.mall;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.controller.BaseController;
import com.mmc.pms.model.group.Insert;
import com.mmc.pms.model.mall.MallGoodsVO;
import com.mmc.pms.model.sale.qo.MallGoodsInfoQO;
import com.mmc.pms.service.mall.MallGoodsService;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2023/7/24 16:56 概要：
 */
@RestController
@RequestMapping("/mall/goods")
@Api(tags = {"V1.0.3-商城商品-相关接口"})
public class MallGoodsController extends BaseController {
    @Resource
    private MallGoodsService mallGoodsService;

    @ApiOperation(value = "新增商城商品")
    @PostMapping("addMallGoods")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addMallGoods(@Validated(value = {Insert.class}) @RequestBody MallGoodsVO mallGoodsVO, HttpServletRequest request) {
        return mallGoodsService.addMallGoods(mallGoodsVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "商城商品详情")
    @GetMapping("mallGoodsDetails")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsVO.class)})
    public ResultBody<MallGoodsVO> mallGoodsDetails(@RequestParam Integer id) {
        System.out.println(id);
        return mallGoodsService.mallGoodsDetails(id);
    }

    @ApiOperation(value = "编辑商城商品")
    @PostMapping("editMallGoods")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editMallGoods(@RequestBody MallGoodsVO mallGoodsVO, HttpServletRequest request) {
        return mallGoodsService.editMallGoods(mallGoodsVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

//    @ApiOperation(value = "单位信息")
//    @GetMapping("getSkuUnit")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = SkuUnitDTO.class)})
//    public ResultBody getSkuUnit() {
//        return mallGoodsService.getSkuUnit();
//    }

    @ApiOperation(value = "商品列表-分页")
    @PostMapping("listPageGoodsInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsVO.class)})
    public ResultBody<MallGoodsVO> listPageGoodsInfo(@ApiParam("商品查询条件QO") @RequestBody MallGoodsInfoQO param, HttpServletRequest request) {
        return ResultBody.success(mallGoodsService.listPageGoodsInfo(param, this.getUserLoginInfoFromRedis(request)));
    }

    @ApiOperation(value = "商品列表-排序")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("exchange")
    public ResultBody exchange(@ApiParam(value = "第一个商品id", required = true) @RequestParam(value = "firstId") Integer firstId,
                               @ApiParam(value = "第二个商品id", required = true) @RequestParam(value = "secondId") Integer secondId) {
        return mallGoodsService.exchange(firstId, secondId);
    }

    @ApiOperation(value = "商品列表-上架或下架")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("upOrDownShelf")
    public ResultBody upOrDownShelf(@ApiParam(value = "商品id", required = true) @RequestParam(value = "id") Integer id,
                                    @ApiParam(value = "状态 0：下架 1： 上架", required = true) @RequestParam(value = "status") Integer status) {
        return mallGoodsService.upOrDownShelf(id, status);
    }

    @ApiOperation(value = "商品列表-删除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeMallGoods")
    public ResultBody removeMallGoods(@ApiParam(value = "商品id", required = true) @RequestParam(value = "id") Integer id) {
        return mallGoodsService.removeMallGoods(id);
    }

    @ApiOperation(value = "删除用户时对应的商品也删除", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("feignRemoveGoodsByBackUserAccountId")
    public ResultBody feignRemoveGoodsByUserAccountId(@RequestParam(value = "id") Integer id, @RequestParam(value = "companyInfoId") Integer companyInfoId) {
        return mallGoodsService.feignRemoveGoodsByBackUserAccountId(id, companyInfoId);
    }

    @ApiOperation(value = "根据话题id查询商城商品详情列表")
    @PostMapping("GoodsInfoByGambitId")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsVO.class)})
    public ResultBody<MallGoodsVO> goodsInfoByGambitIds(@RequestBody GambitIdsVO gambitIds) {
        return mallGoodsService.goodsInfoByGambitId(gambitIds);
    }

}
