package com.mmc.pms.model.sale.qo;

import com.mmc.pms.common.Page;
import com.mmc.pms.model.group.Freeze;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author LW
 * @date 2022/3/22 9:44 概要：商品列表查询QO
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MallGoodsQO {
    @ApiModelProperty(value = "商品名称", example = "商品名称")
    private String tradeName;

    @ApiModelProperty(value = "商品一级分类", example = "1")
    private Integer categoryPrimaryId;

    @ApiModelProperty(value = "用户id", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "商品状态 0：下架 1：上架")
    private Integer shelfStatus;

    @ApiModelProperty(value = "页码", required = true, example = "1")
    @NotNull(
            message = "页码不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true, example = "10")
    @NotNull(
            message = "每页显示数不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
